/*
 * *
 *  * @(#)ITriggerApi.java 2.0.0 18-11-28 下午3:25
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.TriggerReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.Min;

/**
 * @author luo.lei
 * @since 2.0.0
 */
@Api(tags = {"促销中心:触发器API"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-promotion-api-activity-base-service-ITriggerApi", name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}", path = "/v2/trigger", url = "${yundt.cube.center.promotion.api:}")
public interface ITriggerApi {
    /**
     * 新增触发器
     *
     * @param dto 触发器
     * @return id
     */
    @PostMapping("")
    @ResponseBody
    @ApiOperation(value = "新增触发器", notes = "新增触发器")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "coupon", value = "触发器DTO", dataType = "DavinciTriggerReqDto", paramType = "body", required = true)
    })
    RestResponse<Long> addTrigger(@Valid @RequestBody TriggerReqDto dto);

    /**
     * 修改触发器
     *
     * @param dto 触发器，除ID外其他被填充值即为修改项
     * @return 无结果返回 不报错即为操作成功
     */
    @PutMapping("/{id}")
    @ResponseBody
    @ApiOperation(value = "修改触发器", notes = "修改触发器")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "触发器编号ID", dataType = "Long", paramType = "path", required = true),
            @ApiImplicitParam(name = "coupon", value = "触发器DTO", dataType = "DavinciTriggerReqDto", paramType = "body", required = true)
    })
    RestResponse<String> modifyTrigger(@Valid @Min(value = 1, message = "触发器ID不能小于1") @PathVariable(name = "id") Long id,@Valid @RequestBody TriggerReqDto dto);

    /**
     * 删除触发器 -- 逻辑删除
     *
     * @param tId 条件模版ID
     * @return 无结果返回 不报错即为操作成功
     */
    @DeleteMapping("{tId}")
    @ResponseBody
    @ApiOperation(value = "删除触发器", notes = "逻辑删除")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "tId", value = "触发器编号ID", dataType = "Long", paramType = "path", required = true)
    })
    RestResponse<String> deleteTrigger(@Min(value = 1, message = "触发器ID不能小于1") @PathVariable(name = "tId") Long tId);
}
