package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityExtDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityListRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.ActivityItemBranchReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.response.ActivityItemBranchRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.response.PointExchangeActivityRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author chen.fangliang
 * @date 2019/7/8 20:56
 */
@Api(tags = {"营销中心扩展：活动管理查询服务"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-marketing-api-activity-base-service-query-IActivityExtQueryApi", 
        name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}",
        path = "/v2/activity/ext",
        url = "${yundt.cube.center.promotion.api:}"
)
public interface IActivityExtQueryApi {

    /**
     * 分页查询活动列表
     *
     * @param activityDto 查询条件
     * @param pageNum     页数
     * @param pageSize    页大小
     * @return 匹配的活动列表
     */
    @GetMapping({"/list"})
    @ApiOperation(value = "分页查询活动列表", notes = "根据查询条件查询活动列表,包含审核人")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNum", value = "当前页面", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", value = "页面大小", dataType = "int", paramType = "query")
    })
    RestResponse<PageInfo<ActivityListRespDto>> queryActivityPage(@SpringQueryMap ActivityExtDto activityDto,
                                                                  @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                  @RequestParam(value = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 根据多个活动类型分页查询活动
     *
     * @param pageNum    pageNum
     * @param pageSize   pageSize
     * @param statusList 活动状态列表
     * @return 活动列表
     */
    @GetMapping("/page/types")
    @ApiOperation(value = "根据多个活动状态分页查询活动", notes = "参与积分兑换促销活动")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNum", value = "当前页面", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", value = "页面大小", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "status", value = "活动状态（NEW：新建、READY：就绪、ACTIVATE：活动中、PAUSE：暂停、FINISH：活动结束)", dataType = "array", paramType = "query",required = true),
            @ApiImplicitParam(name = "activityName", value = "活动名称", dataType = "String", paramType = "query")
    })
    RestResponse<PageInfo<ActivityRespDto>> queryActivityByActivityStatus(@RequestParam(value = "status") List<String> statusList,
                                                                          @RequestParam(value = "activityName",required = false) String activityName,
                                                                          @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                          @RequestParam(value = "pageSize", required = false, defaultValue = "10") Integer pageSize);


    /**
     * 根据多个活动id查询活动列表
     *
     * @param idList 活动id集合
     * @return 活动列表
     */
    @GetMapping("/list/by-ids")
    @ApiOperation(value = "根据多个活动id查询活动列表", notes = "根据多个活动id查询活动列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "idList", value = "活动id集合", dataType = "array", paramType = "query",required = true)
    })
    RestResponse<List<ActivityRespDto>> queryActivityListByIds(@RequestParam("idList") List<Long> idList);

    /**
     * 根据id活动
     *
     * @return 活动列表
     */
    @GetMapping("/id/")
    @ApiOperation(value = "", notes = "参与积分兑换促销活动")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "活动id", dataType = "Long", paramType = "query", required = true)
    })
    RestResponse<ActivityRespDto> queryActivityById(@RequestParam("id") Long id);


    /**
     * 积分兑换商品列表查询。
     *
     * @param activityTemplateId 活动模版ID
     * @param memberId           会员ID 可为0
     * @param shopCode           店铺ID 可为null
     * @param itemCode           商品编码 可为null
     * @return 可参与活动的商品列表
     */
    @GetMapping("point/exchange")
    @ApiOperation(value = "根据活动模板id查询 积分兑换商品列表", notes = "根据活动模板id查询 积分兑换商品列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "activityTemplateId", value = "活动模板id", dataType = "Long", paramType = "query",required = true),
            @ApiImplicitParam(name = "memberId", value = "会员id", dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "shopCode", value = "店铺编号", dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "itemCode", value = "商品编号", dataType = "String", paramType = "query")
    })
    RestResponse<List<PointExchangeActivityRespDto>> pointExchangeItem(@RequestParam("activityTemplateId") Long activityTemplateId,
                                                                       @RequestParam(value = "memberId", required = false, defaultValue = "0") long memberId,
                                                                       @RequestParam(value = "shopCode", required = false, defaultValue = "") String shopCode,
                                                                       @RequestParam(value = "itemCode", required = false, defaultValue = "") String itemCode);

    /**
     * 批量查询活动商品信息
     *
     * @return 批量查询活动商品信息
     */
    @GetMapping("/item/branch")
    @ApiOperation(value = "", notes = "批量查询活动商品信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "批量查询活动商品信息", dataType = "Long", paramType = "query", required = true)
    })
    RestResponse<ActivityItemBranchRespDto> queryActivityItemBranch(ActivityItemBranchReqDto activityItemBranchReqDto);

    /**
     * 批量查询活动商品信息
     *
     * @return 批量查询活动商品信息
     */
    @GetMapping("/queryExchangeActivityDetailById/{id}")
    @ApiOperation(value = "", notes = "根据活动id查询换购活动详情包含换购商品信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "根据活动id查询换购活动详情包含换购商品信息", dataType = "Long", paramType = "query", required = true)
    })
    RestResponse<ActivityRespDto> queryExchangeActivityDetailById(@PathVariable("id") Long id);

    /**
     * 根据活动id集合查询换购活动详情包含换购商品信息
     *
     * @return
     */
    @PostMapping("/queryExchangeActivityDetailByIds")
    @ApiOperation(value = "", notes = "根据活动id集合查询换购活动详情包含换购商品信息")
    RestResponse<List<ActivityRespDto>> queryExchangeActivityDetailByIds(@RequestBody List<Long> ids);

}
