package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityItemQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityItemRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * Created by guangzuo on 2018/12/3.
 */
@Api(tags = {"促销中心:商品活动操作API"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-promotion-api-activity-base-service-query" +
        "-IActivityItemQueryApi", name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}", path
        = "/v2/activity/item", url = "${yundt.cube.center.promotion.api:}")
public interface IActivityItemQueryApi {

    /**
     * 查询活动商品详情
     *
     * @param id 活动商品id
     * @return 活动商品详情
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据ID查询活动商品详情", notes = "根据ID查询活动商品详情")
    RestResponse<ActivityItemRespDto> queryById(@NotNull(message = "ID不允许为空") @PathVariable("id") Long id);

    /**
     * 查询活动商品列表
     *
     * @param activityItemQueryReqDto
     * @return 活动商品列表
     */
    @GetMapping("/query")
    @ApiOperation(value = "条件查询活动商品列表", notes = "条件查询活动商品列表")
    RestResponse<List<ActivityItemRespDto>> queryAll(@SpringQueryMap @Valid ActivityItemQueryReqDto activityItemQueryReqDto);

    /**
     * 根据活动查询关联的商品id
     *
     * @param activityTemplateId 活动模板id
     * @param activityId         活动id
     * @return
     */
    @GetMapping("/queryByActivity")
    @ApiOperation(value = "根据活动activityTemplateId、activityId查询活动商品列表", notes = "根据活动activityTemplateId、activityId" +
            "查询活动商品列表")
    RestResponse<List<ActivityItemRespDto>> queryByActivity(@RequestParam(value = "activityTemplateId", required =
            false) Long activityTemplateId,
                                                            @RequestParam(value = "activityId", required = false) Long activityId);


    @GetMapping("/isApplicable")
    @ApiOperation(value = "判断商品是否适用活动", notes = "判断商品是否适用活动")
    RestResponse<Boolean> isApplicable(@RequestParam("itemId") Long itemId,
                                       @RequestParam(value = "skuId", required = false) Long skuId,
                                       @RequestParam(value = "activityId") Long activityId,
                                       @RequestParam(value = "shopId") Long shopId);

    @GetMapping("/{activityId}/{itemId}")
    @ApiOperation(value = "查询活动商品价格库存", notes = "返回活动商品价格及库存，优先走缓存")
    RestResponse<List<ActivityItemRespDto>> queryActivityItems(@PathVariable("activityId") Long activityId,
                                                               @PathVariable("itemId") Long itemId);
}
