package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityJoinLogReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityJoinLogExtRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;

import java.util.List;

/**
 * @author chen.fangliang
 * @date 2019/7/29 13:52
 */
@Api(tags = {"促销中心:活动日志查询接口"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-marketing-api-activity-base-service-query-IActivityJoinLogExtQueryApi", 
        name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}",
        url = "${yundt.cube.center.promotion.api:}",
        path = "/v1/activity/log/ext"
)
public interface IActivityJoinLogExtQueryApi {

    /**
     * 查询活动参与记录
     *
     * @param reqDto 请求
     * @return
     */
    @GetMapping("/list")
    @ApiOperation(value = "查询活动参与记录", notes = "查询活动参与记录")
    RestResponse<List<ActivityJoinLogExtRespDto>> queryList(@SpringQueryMap ActivityJoinLogReqDto reqDto);

    /**
     * 查询活动参与记录
     *
     * @param reqDto 请求
     * @return
     */
    @GetMapping("/page")
    @ApiOperation(value = "分页查询活动参与记录", notes = "分页查询活动参与记录")
    RestResponse<PageInfo<ActivityJoinLogExtRespDto>> queryPage(@SpringQueryMap ActivityJoinLogReqDto reqDto);
}
