/**
 * @(#)IActivityOverlapRuleQueryApi.java 1.0 2021/3/8
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityOverlapRuleRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

import java.util.List;

/**
 * 活动叠加配置规则
 *
 * @author wu.sheng
 * @date 2021/3/8 15:43
 */
@Api(tags = {"促销中心:活动叠加规则配置"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-promotion-api-activity-base-service-query-IActivityOverlapRuleQueryApi",
        name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}",
        path = "/v2/activity-overlap-rule",
        url = "${yundt.cube.center.promotion.api:}")
public interface IActivityOverlapRuleQueryApi {

    /**
     * 根据活动模板id查询可配置的活动模板列表
     *
     * @param activityTpId 活动模板id
     * @return
     */
    @GetMapping("/{activityTpId}")
    @ApiOperation(value = "根据活动模板id查询可配置的活动模板列表", notes = "根据活动模板id查询可配置的活动模板列表")
    RestResponse<List<ActivityOverlapRuleRespDto>> queryByActivityTpId(@PathVariable("activityTpId") Long activityTpId);
}
