/*
 * *
 *  * @(#)IActivityQueryApi.java 2.0.0 18-11-28 下午3:26
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityItemListReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityTagQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.*;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import java.util.List;
import java.util.Set;

/**
 * 活动服务接口
 *
 * @author 魄罗
 * @since 2.0.0
 */
@Api(tags = {"促销中心:活动管理查询服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-promotion-api-activity-base-service-query-IActivityQueryApi", name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}", path = "/v2/activity", url = "${yundt.cube.center.promotion.api:}")
public interface IActivityQueryApi {

    /**
     * 查询活动基本信息
     *
     * @param acId 活动ID
     * @return 活动详情
     */
    @GetMapping("/{acId}")
    @ApiOperation(value = "根据活动id查询活动基本信息", notes = "查询活动基本信息、模板信息,活动不存在会抛异常")
    RestResponse<ActivityRespDto> queryActivityDetail(@Min(value = 1, message = "请传入合法活动ID")
                                             @PathVariable("acId") long acId);

    /**
     * 查询活动详情包含活动配置参数
     * 特殊用途
     *
     * @param acId 活动ID
     * @return 活动详情
     */
    @GetMapping("/fat/{acId}")
    @ApiOperation(value = "根据活动id查询活动详情", notes = "查询活动详情包含活动配置参数")
    RestResponse<ActivityRespDto> queryActivityFatDetail(@Min(value = 1, message = "请传入合法活动ID")
                                                         @PathVariable("acId") long acId);

    /**
     * 通过检查点查询正在运营中的活动
     *
     * @param checkPoint 检查点
     * @return 活动ID
     */
    @GetMapping("/cp/{checkPoint}")
    @ApiOperation(value = "查询在运营中的活动", notes = "通过检查点查询正在运营中的活动")
    RestResponse<List<Long>> queryActuatingByCp(@NotBlank(message = "请传入checkPoint值")
                                                @PathVariable("checkPoint") String checkPoint);

    /**
     * 查询活动列表
     *
     * @param queryDto
     * @return 结果集
     */
    @GetMapping("/list")
    @ApiOperation(value = "查询活动列表", notes = "根据查询条件查询活动列表")
    RestResponse<List<ActivityRespDto>> queryActivityList(@SpringQueryMap ActivityDto queryDto);

    /**
     * 分页查询活动列表
     *
     * @param queryDto
     * @param pageNum
     * @param pageSize
     * @return 结果集
     */
    @GetMapping("/page")
    @ApiOperation(value = "查询活动分页列表", notes = "根据查询条件查询活动列表")
    RestResponse<PageInfo<ActivityRespDto>> queryActivityPage(@SpringQueryMap ActivityDto queryDto,
                                                              @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                              @RequestParam(value = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 简单版反向查询方式：查询商品或者用户可参与的活动列表，
     * 限制条件报错活动时请填充
     *
     * @param itemId      商品ID 无请传0
     * @param userId      用户ID 无请传0 但不可两个都为0
     * @param validStatus 是否只查有效的活动，即进行中的活动
     * @return 可参与活动列表
     * @see com.dtyunxi.yundt.cube.center.promotion.api.activity.base.dto.request.ActivityCreateReqDto#setActivityItems
     * 如果商品规则比较复杂，比如全类目全店铺甚至有全类目加排除某商品的
     * 请使用查询{@link com.dtyunxi.yundt.cube.center.promotion.api.activity.base.enums.ActivityStatusEnum#ACTIVATE }状态活动
     * 然后使用
     * @see com.dtyunxi.yundt.cube.center.marketing.engine.core.Checkpoint#execute
     */
    @GetMapping("list/inverse")
    @ApiOperation(value = "简单版反向查询方式", notes = "查询商品或者用户可参与的活动列表")
    RestResponse<List<ActivityRespExtDto>> inverseQuery(@RequestParam("itemId") long itemId, @RequestParam("userId") long userId, @RequestParam("validStatus") boolean validStatus);


    /**
     * 查询活动审核信息
     *
     * @param activityId 活动ID
     * @return 审核信息
     */
    @GetMapping("/{activityId}/audit")
    @ApiOperation(value = "通过活动id查询活动审核信息", notes = "查询活动审核信息")
    RestResponse<List<ActivityRespDto>> queryAuditData(@PathVariable("activityId") long activityId);


    /**
     * 批量查询活动商品价格列表
     * @param activityItemListReqDto 活动查询商品列表
     * @return 批量查询活动商品价格列表
     */
    @GetMapping("/price/list")
    @ApiOperation(value = "批量查询活动商品价格列表", notes = "批量查询活动商品价格列表")
    @Deprecated
    RestResponse<List<ItemActivityPriceMkRespDto>> queryItemActivityPrice(ActivityItemListReqDto activityItemListReqDto);

    /**
     * 根据活动id查询可叠加的活动模板id
     *
     * @param activityId
     * @return
     */
    @GetMapping("/{activityId}/relation/list")
    @ApiOperation(value = "根据活动id查询可叠加的活动模板id", notes = "根据活动id查询可叠加的活动模板id")
    RestResponse<List<ActivityRelationRespDto>> queryActivityRelations(@PathVariable("activityId") Long activityId);

    /**
     * 下单预览可用的促销活动和优惠券
     *
     * @param engineParams
     * @return
     */
    @PostMapping("/preview")
    @ApiOperation(value = "下单预览可用的促销活动和优惠券（ICOM定制接口）", notes = "下单预览可用的促销活动和优惠券")
    RestResponse<PreviewActivityRespDto> previewActivity(@RequestBody EngineParams engineParams);

    /**
     * 根据商品查询对应的促销活动和优惠券
     *
     * @param itemActivityTagQueryReqDto
     * @return
     */
    @GetMapping("/view/item")
    @ApiOperation(value = "根据商品查询对应的促销活动和优惠券（B端定制接口）", notes = "根据商品查询对应的促销活动和优惠券（B端定制接口）")
    RestResponse<PromotionCouponRespDto> queryActivityByItem(@SpringQueryMap ItemActivityTagQueryReqDto itemActivityTagQueryReqDto);

    /**
     * 根据活动id集合查询模板id
     *
     * @param activityIds
     * @return
     */
    @PostMapping("/queryActivityTemIdsByIds")
    @ApiOperation(value = "根据活动id集合查询模板id", notes = "根据活动id集合查询模板id")
    RestResponse<List<Long>> queryActivityTemIdsByIds(@RequestBody Set<Long> activityIds);


}
