/**
 * @(#)IActivityRelationApi.java 1.0 2021/3/15
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityRelationReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityRelationExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityRelationRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;

import java.util.List;

/**
 * 活动关系服务
 *
 * @author wu.sheng
 * @date 2021/3/15 16:58
 */
@Api(tags = {"促销中心:活动关系服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-promotion-api-activity-base-service-query-IActivityRelationQueryApi",
        name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}",
        path = "/v2/activity-relation",
        url = "${yundt.cube.center.promotion.api:}")
public interface IActivityRelationQueryApi {

    @GetMapping("/list")
    @ApiOperation(value = "查询活动关系", notes = "查询活动关系")
    RestResponse<List<ActivityRelationRespDto>> query(@ModelAttribute ActivityRelationReqDto activityRelationReqDto);

    @GetMapping("/ext/list")
    @ApiOperation(value = "查询活动关系扩展信息", notes = "查询活动关系扩展信息")
    RestResponse<List<ActivityRelationExtRespDto>> queryExt(@ModelAttribute ActivityRelationReqDto activityRelationReqDto);
}
