package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query;


import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityRuleItemRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.GetMapping;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * 服务接口
 *
 * @author yuangui
 * @since 2021-11-26
 */
@Api(tags = {"服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-icom-bundle-base-center-promotion-api-query-IActivityRuleItemQueryApi",
        name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}",
        path = "/v1/rule/item",
        url = "${yundt.cube.center.promotion.api:}"
)
public interface IActivityRuleItemQueryApi {

    /**
     * 根据id查询
     *
     * @param id id
     * @return   数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询", notes = "根据id查询")
    RestResponse<ActivityRuleItemRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 分页数据
     *
     * @param filter   查询条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return 分页数据
     */
    @GetMapping("/page")
    @ApiOperation(value = "分页数据", notes = "根据filter查询条件查询数据，filter=ActivityRuleItemReqDto")
    RestResponse<PageInfo<ActivityRuleItemRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                                @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 根据活动ids查询活动关联商品
     *
     * @param ids 活动ids
     * @return
     */
    @PostMapping("/list/activityIds")
    @ApiOperation(value = "根据活动ids查询活动关联商品")
    @ApiImplicitParam(name = "ids", value = "活动ids", dataType = "array", paramType = "query")
    RestResponse<List<ActivityRuleItemRespDto>> queryActivityRuleItemByActivityIds(@RequestParam("ids") List<Long> ids);
}
