package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityPersonQueryDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityShareLinkDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityShareLinkGroupDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityShareLinkPersonDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

import java.util.List;

/**
 * @author shenfei
 */
@Api(tags = {"促销中心:社群分析"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-marketing-api-activity-base-service-query-IActivityShareLinkAnalysisQueryApi",
        name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}",
        url = "${yundt.cube.center.promotion.api:}",
        path = "/v1/activity/share/link/analysis"
)
public interface IActivityShareLinkAnalysisQueryApi {

    /**
     * 获取活动的社群列表
     * @param actId
     * @return
     */
    @GetMapping("/group/{actId}")
    @ApiOperation(value = "获取活动的社群列表", notes = "获取活动的社群列表")
    RestResponse<List<ActivityShareLinkGroupDto>> listActivityGroup(@PathVariable("actId") Long actId);

    /**
     * 获取社群人员列表
     * @param dto
     * @return
     */
    @GetMapping("/group/person")
    @ApiOperation(value = "获取社群人员列表", notes = "获取社群人员列表")
    RestResponse<PageInfo<ActivityShareLinkPersonDto>> pageActivityPerson(@SpringQueryMap ActivityPersonQueryDto dto);

    /**
     * 获取社群人员图信息列表
     * @param groupPersonId
     * @return
     */
    @GetMapping("/group/person/{actId}/{groupPersonId}")
    @ApiOperation(value = "获取社群人员图信息列表", notes = "获取社群人员图信息列表")
    RestResponse<List<ActivityShareLinkDto>> listActivityGroupPerson(@PathVariable("actId") Long actId, @PathVariable("groupPersonId") Long groupPersonId);

}
