/*
 * *
 *  * @(#)IActivityTemplateQueryApi.java 2.0.0 18-11-28 下午3:26
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityTemplateQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityTemplateRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 活动服务接口
 *
 * @author 魄罗
 * @since 2.0.0
 */
@Api(tags = {"促销中心:活动模版服务"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-promotion-api-activity-base-service-query-IActivityTemplateQueryApi", name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}", path = "/v2/activity-template", url = "${yundt.cube.center.promotion.api:}")
public interface IActivityTemplateQueryApi {

    /**
     * 查询活动模版详情
     *
     * @param id     主键ID
     * @return 活动模版详情
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据活动模版ID查询活动模版信息", notes = "根据活动模版ID查询活动模版信息")
    RestResponse<ActivityTemplateRespDto> queryActivityTemplateDetail(@NotNull(message = "ID不允许为空") @PathVariable("id") Long id);

    /**
     * 查询活动模版列表
     *
     * @param activityTemplateQueryReqDto 的JSONString
     * @return 活动模版集合
     */
    @GetMapping("/list")
    @ApiOperation(value = "根据查询条件查询活动模版集合", notes = "根据查询条件查询活动模版集合")
    RestResponse<List<ActivityTemplateRespDto>> queryActivityTemplateList(@SpringQueryMap @Valid ActivityTemplateQueryReqDto activityTemplateQueryReqDto);

    /**
     * 分页查询活动模版列表
     *
     * @param activityTemplateQueryReqDto 的JSONString
     * @param pageNum
     * @param pageSize
     * @return 分页的活动模版信息
     */
    @GetMapping("/page")
    @ApiOperation(value = "根据查询条件查询活动模版集合-分页", notes = "根据查询条件查询活动模版集合-分页")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNum", value = "当前页", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", value = "页面大小", dataType = "int", paramType = "query")
    })
    RestResponse<PageInfo<ActivityTemplateRespDto>> queryActivityTemplatePage(@SpringQueryMap ActivityTemplateQueryReqDto activityTemplateQueryReqDto,
                                                                              @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                              @RequestParam(value = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
