package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.CheckPointQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.CheckpointRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 检查点
 *
 * @author tuyun
 * @since 2.0.0
 */
@Api(tags = {"促销中心:检查点服务"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-promotion-api-activity-base-service-query-ICheckpointQueryApi", name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}", path = "/v2/check-point", url = "${yundt.cube.center.promotion.api:}")
public interface ICheckpointQueryApi {

//    /**
//     * 分页模糊查询检查点列表
//     *
//     * @param checkpointReqDto
//     * @param page
//     * @return
//     */
//    RestResponse<PageInfo> queryCheckpoints(CheckPointReqDto checkpointReqDto, Page page);

    /**
     * 查询检查点详情
     *
     * @param id 主键ID
     * @return 检查点详情
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据检查点ID查询检查点信息", notes = "根据检查点ID查询检查点信息")
    RestResponse<CheckpointRespDto> queryCheckPointDetail(@NotNull(message = "ID不允许为空") @PathVariable("id") Long id);

    /**
     * 查询检查点列表
     *
     * @param checkPointQueryReqDto 查询条件
     * @return 检查点集合
     */
    @GetMapping("/list")
    @ApiOperation(value = "根据查询条件查询检查点集合", notes = "根据查询条件查询检查点集合")
    RestResponse<List<CheckpointRespDto>> queryCheckPointList(@Valid @SpringQueryMap CheckPointQueryReqDto checkPointQueryReqDto);

    /**
     * 分页查询检查点列表
     *
     * @param checkPointQueryReqDto 查询条件
     * @param pageNum
     * @param pageSize
     * @return 分页的检查点信息
     */
    @GetMapping("/page")
    @ApiOperation(value = "根据查询条件查询检查点集合-分页", notes = "根据查询条件查询检查点集合-分页")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNum", value = "当前页", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", value = "页面大小", dataType = "int", paramType = "query")
    })
    RestResponse<PageInfo<CheckpointRespDto>> queryCheckPointPage(@Valid @SpringQueryMap CheckPointQueryReqDto checkPointQueryReqDto,
                                                                  @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                  @RequestParam(value = "pageSize", required = false, defaultValue = "10") Integer pageSize);


}
