/*
 * *
 *  * @(#)IConditionQueryApi.java 2.0.0 7/13/19 2:43 PM
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query;

import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 活动实例查询接口
 * @author luo.lei
 * @since 2.0.0
 */
@Api(tags = {"促销中心:活动实例查询接口"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-promotion-api-activity-base-service-query-IConditionQueryApi", name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}", path = "/v2/condition", url = "${yundt.cube.center.promotion.api:}")
public interface IConditionQueryApi {


    /**
     * 查询活动下对应条件模版的配置参数
     * @param acIds 活动列表
     * @param conditionTemplateId 条件模版ID ，可为0表示查询所有条件模版
     * @return 匹配的配置参数，无结果时返回空列表
     */
    @GetMapping("/activities")
    @ApiOperation(value = "询活动下对应条件模版的配置参数", notes = "询活动下对应条件模版的配置参数")
    List<ConditionRespDto> queryConditions(@Valid @NotNull @RequestParam("acIds") List<Long> acIds , @RequestParam("conditionTemplateId") long conditionTemplateId) ;

    /**
     * 查询根据活动ID列表和条件模板ID
     * @param activityId
     * @param conditionTemplateId
     * @return
     */
    @PostMapping("/queryConditionListByActivitys")
    @ApiOperation(value = "查询根据活动ID列表和条件模板ID", notes = "查询根据活动ID列表和条件模板ID")
    List<ConditionRespDto> queryConditionListByActivitys(@RequestParam("activityId") List<Long> activityId,@RequestParam("conditionTemplateId")Long conditionTemplateId);
}
