package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ConditionTemplateQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ConditionTemplateRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 条件模板
 *
 * @author tuyun
 * @since 2.0.0
 */
@Api(tags = {"促销中心:条件模板API"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-promotion-api-activity-base-service-query-IConditionTemplateQueryApi", name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}", path = "/v2/condition-template", url = "${yundt.cube.center.promotion.api:}")
public interface IConditionTemplateQueryApi {

    /**  主键 分页
     * 根据条件模板编号查询条件模板
     *
     * @param  id 条件模板id
     * @return 条件模板详情
     */
     @GetMapping("/{id}")
     @ApiOperation(value = "根据条件模板id查询条件模板详情", notes = "根据条件模板id查询条件模板详情")
      RestResponse<ConditionTemplateRespDto> queryConditionTemplates(@NotNull(message = "条件模板id不能为空")@PathVariable(name = "id") Long id);
    /**
     * 查询条件模版列表

     * @return 条件模版集合
     */
    @GetMapping("/list")
    @ApiOperation(value = "根据查询条件查询条件模版集合", notes = "根据查询条件查询条件模版集合")
    RestResponse<List<ConditionTemplateRespDto>> queryConditionTemplateList(@Valid  @SpringQueryMap ConditionTemplateQueryReqDto conditionTemplateQueryReqDto);
    /**
     *
     * @param   conditionTemplateQueryReqDto
     * @param pageNum
     * @param pageSize
     * @return 分页的条件模板信息
     */
    @GetMapping("/page")
    @ApiOperation(value = "根据查询条件查询条件模版集合-分页", notes = "根据查询条件查询条件模版集合-分页")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNum", value = "当前页", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", value = "页面大小", dataType = "int", paramType = "query")
    })
    RestResponse<PageInfo<ConditionTemplateRespDto>> queryConditionTemplatePage(@Valid  @SpringQueryMap ConditionTemplateQueryReqDto conditionTemplateQueryReqDto,
                                                                              @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                              @RequestParam(value = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 根据id集批量查询条件模板
     *
     * @param ids 条件模板id集合
     * @return
     */
    @GetMapping("/list/batch")
    @ApiOperation(value = "根据id集批量查询条件模板")
    @ApiImplicitParam(name = "ids", value = "条件模板id集合", dataType = "array", paramType = "query")
    RestResponse<List<ConditionTemplateRespDto>> queryConditionTemplateBatch(@RequestParam("ids") List<Long> ids);

}
