/**
 * @(#)ItemActivityPriceQueryApi.java 1.0 2021/3/9
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityPriceDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityPriceQueryReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;

import java.util.List;

/**
 * 商品活动价格服务
 *
 * @author wu.sheng
 * @date 2021/3/9 14:07
 */
@Api(tags = {"促销中心:商品活动价格服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-promotion-api-activity-base-service-query-IItemActivityPriceQueryApi",
        name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}",
        path = "/v2/item-activity-price",
        url = "${yundt.cube.center.promotion.api:}")
public interface IItemActivityPriceQueryApi {

    /**
     * 查询商品活动价格列表
     *
     * @param queryReqDto
     * @return
     */
    @GetMapping("/list")
    @ApiOperation(value = "查询商品活动价格列表", notes = "查询商品活动价格列表")
    RestResponse<List<ItemActivityPriceDto>> queryList(@SpringQueryMap ItemActivityPriceQueryReqDto queryReqDto);
}
