/**
 * @(#)IItemActivityTagQueryApi.java 1.0 2020/5/20
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityTagDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityTagQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.fallback.ItemActivityTagFallBack;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 商品活动标签
 *
 * @author wu.sheng
 * @date 2020/5/20 18:16
 */
@Api(tags = {"促销中心:商品活动标签API"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-promotion-api-activity-base-service-query" +
        "-IItemActivityTagQueryApi",
        name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}",
        path = "/v2/item/activity-tag",
        url = "${yundt.cube.center.promotion.api:}",fallback = ItemActivityTagFallBack.class)
public interface IItemActivityTagQueryApi {

    /**
     * 分页查询查询商品活动标签列表
     *
     * @param itemActivityTagQueryReqDto
     * @param pageNum
     * @param pageSize
     * @return
     */
    @GetMapping("/page")
    @ApiOperation(value = "分页查询商品活动标签列表", notes = "分页查询商品活动标签列表")
    RestResponse<PageInfo<ItemActivityTagDto>> queryByPage(@SpringQueryMap ItemActivityTagQueryReqDto itemActivityTagQueryReqDto,
                                                           @RequestParam("pageNum") Integer pageNum,
                                                           @RequestParam("pageSize") Integer pageSize);


    /**
     * 查询商品活动标签列表
     *
     * @param itemActivityTagQueryReqDto
     * @return
     */
    @GetMapping("/list")
    @ApiOperation(value = "查询商品活动标签列表", notes = "根据商品id查询商品活动标签列表")
    RestResponse<List<ItemActivityTagDto>> queryList(@SpringQueryMap ItemActivityTagQueryReqDto itemActivityTagQueryReqDto);



}
