/*
 * *
 *  * @(#)PolicyConfigQueryApi.java 2.0.0 18-11-28 下午3:27
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.PolicyQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.PolicyRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 策略配置信息查询
 *
 * @author tuyun
 * @since 2.0.0
 */
@Api(tags = {"促销中心:策略配置信息API"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-promotion-api-activity-base-service-query-IPolicyConfigQueryApi", name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}", path = "/v2/policy", url = "${yundt.cube.center.promotion.api:}")
public interface IPolicyConfigQueryApi {
    /**
     * 根据检查点编号查询策略集合，策略包含规则、条件模板、动作模板等级联信息
     *
     * @param checkpointCode
     * @return
     */
    @GetMapping("/check-point/{checkpointCode}")
    @ApiOperation(value = "根据检查点编号获取规则配置", notes = "根据检查点编号获取规则配置")
    RestResponse<List<PolicyRespDto>> queryPoliciesByCheckpoint(@PathVariable(name = "checkpointCode") String checkpointCode);

    /**
     * 根据活动编号&检查点编号查询策略集合，策略包含规则、条件模板、动作模板等级联信息
     *
     * @param activityId
     * @param checkpointCode
     * @return
     */
    @GetMapping("{activityId}/{checkpointCode}")
    @ApiOperation(value = "获取规则配置", notes = "通过活动ID和检查点")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "activityId", value = "活动ID", dataType = "Long", paramType = "path",required = true),
            @ApiImplicitParam(name = "checkpointCode", value = "检查点编码", dataType = "String", paramType = "path",required = true)
    })
    RestResponse<List<PolicyRespDto>> queryPoliciesByActIdAndCheckpoint(@PathVariable(name = "activityId") Long activityId, @PathVariable(name = "checkpointCode") String checkpointCode);

    /**
     * 根据活动编号查询对应的条件实例配置信息
     *
     * @param activityId
     * @return
     */
    @GetMapping("/activity/condition/{activityId}")
    @ApiOperation(value = "获取条件实例", notes = "通过活动ID")
    RestResponse<List<ConditionRespDto>> queryConditionsByActivityId(@PathVariable(name = "activityId") Long activityId);

    /**
     * 根据活动编号查询对应的动作实例的配置信息
     *
     * @param activityId
     * @return
     */
    @GetMapping("/activity/action/{activityId}")
    @ApiOperation(value = "获取动作实例", notes = "通过活动ID")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "activityId", value = "活动ID", dataType = "Long", paramType = "path",required = true)
    })
    RestResponse<List<ActionRespDto>> queryActionsByActivityId(@PathVariable(name = "activityId") Long activityId);


    /**
     * 查询策略模版详情
     *
     * @param id 主键ID
     * @return 策略模版详情
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据策略模版ID查询策略模版信息", notes = "根据策略模版ID查询策略模版信息")
    RestResponse<PolicyRespDto> queryPolicyDetail(@NotNull(message = "ID不允许为空") @PathVariable("id") Long id);

    /**
     * 查询策略模版列表
     *
     * @param queryReqDto 查询条件
     * @return 策略模版集合
     */
    @GetMapping("/list")
    @ApiOperation(value = "根据查询条件查询策略模版集合", notes = "根据查询条件查询策略模版集合")
    RestResponse<List<PolicyRespDto>> queryPolicyList(@Valid @SpringQueryMap PolicyQueryReqDto queryReqDto);

    /**
     * 分页查询策略模版列表
     *
     * @param queryReqDto 查询条件
     * @param pageNum
     * @param pageSize
     * @return 分页的策略模版信息
     */
    @GetMapping("/page")
    @ApiOperation(value = "根据查询条件查询策略模版集合-分页", notes = "根据查询条件查询策略模板集合-分页")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNum", value = "当前页", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", value = "页面大小", dataType = "int", paramType = "query")
    })
    RestResponse<PageInfo<PolicyRespDto>> queryPolicyPage(@Valid @SpringQueryMap PolicyQueryReqDto queryReqDto,
                                                          @RequestParam(value = "pageNum", required = false, defaultValue = "1") int pageNum,
                                                          @RequestParam(value = "pageSize", required = false, defaultValue = "10") int pageSize);


}
