package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.RuleQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.RuleRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 规则
 *
 * @author tuyun
 * @since 2.0.0
 */
@Api(tags = {"促销中心:规则模版服务"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-promotion-api-activity-base-service-query-IRuleQueryApi", name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}", path = "/v2/rule", url = "${yundt.cube.center.promotion.api:}")
public interface IRuleQueryApi {

    /**
     * 查询规则模版详情
     *
     * @param id 主键ID
     * @return 活动模版详情
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据规则ID查询规则模版信息", notes = "根据ID查询规则模版信息")
    RestResponse<RuleRespDto> queryRuleDetail(@NotNull(message = "ID不允许为空") @PathVariable("id") Long id);

    /**
     * 查询规则模版列表
     *
     * @param reqDto
     * @return 活动模版集合
     */
    @GetMapping("/list")
    @ApiOperation(value = "根据查询条件查询规则模版集合", notes = "根据查询条件查询规则模版集合")
    RestResponse<List<RuleRespDto>> queryRuleList(@Valid @SpringQueryMap RuleQueryReqDto reqDto);

    /**
     * 分页查询规则模版列表
     *
     * @param reqDto
     * @param pageNum
     * @param pageSize
     * @return 分页的活动模版信息
     */
    @GetMapping("/page")
    @ApiOperation(value = "根据查询条件查询规则模版集合-分页", notes = "根据查询条件查询规则模版集合-分页")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNum", value = "当前页", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", value = "页面大小", dataType = "int", paramType = "query")
    })
    RestResponse<PageInfo<RuleRespDto>> queryRulePage(@Valid @SpringQueryMap RuleQueryReqDto reqDto,
                                                      @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                      @RequestParam(value = "pageSize", required = false, defaultValue = "10") Integer pageSize);


}
