package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.TriggerQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.TriggerRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 触发器
 *
 * @author tuyun
 * @since 2.0.0
 */
@Api(tags = {"促销中心:触发器模板API"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-promotion-api-activity-base-service-query-ITriggerQueryApi", name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}", path = "/v2/trigger", url = "${yundt.cube.center.promotion.api:}")
public interface ITriggerQueryApi {

//    /**
//     * 分页模糊查询触发器列表
//     *
//     * @param triggerReqDto
//     * @param page
//     * @return
//     */
//    RestResponse<PageInfo> queryTriggers(DavinciTriggerReqDto triggerReqDto, Page page);

    /**
     * 查询触发器模版详情
     *
     * @param id     主键ID
     * @return 触发器模版详情
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据触发ID查询触发器模版信息", notes = "根据ID查询触发器模版信息")
    RestResponse<TriggerRespDto> queryTriggerDetail(@NotNull(message = "ID不允许为空") @PathVariable("id") Long id);

    /**
     * 查询触发器模版列表
     *
     * @param triggerQueryReqDto TriggerReqDto的JSONString
     * @return 触发器模版集合
     */
    @GetMapping("/list")
    @ApiOperation(value = "根据查询条件查询触发器模版集合", notes = "根据查询条件查询触发器模版集合")
    RestResponse<List<TriggerRespDto>> queryTriggerList(@Valid  @SpringQueryMap TriggerQueryReqDto triggerQueryReqDto);

    /**
     * 分页查询触发器模版列表
     *
     * @param triggerQueryReqDto   TriggerReqDto的JSONString
     * @param pageNum
     * @param pageSize
     * @return 分页的触发器模版信息
     */
    @GetMapping("/page")
    @ApiOperation(value = "根据查询条件查询触发器模版集合-分页", notes = "根据查询条件查询触发器模版集合-分页")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNum", value = "当前页", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", value = "页面大小", dataType = "int", paramType = "query")
    })
    RestResponse<PageInfo<TriggerRespDto>> queryTriggerPage(@Valid  @SpringQueryMap TriggerQueryReqDto triggerQueryReqDto,
                                                      @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                      @RequestParam(value = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
