package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums;

/**
 * 优惠券批次状态枚举类, WAIT_GEN：待生成、GENERATING：生成中、FINISH_SUCCESS：生成成功、FINISH_FAILED：生成异常
 * @author li.jundong
 * @date: 2019/6/28 9:28
 */
public enum CouponBatchStatusEnum{

    WAIT_GEN("WAIT_GEN", "待生成"),

    GENERATING("GENERATING", "生成中"),

    FINISH_SUCCESS("FINISH_SUCCESS", "生成成功"),

    FINISH_FAILED("FINISH_FAILED", "生成异常"),

    ;

    private String status;

    private String message;

    CouponBatchStatusEnum(String status, String message) {
        this.status = status;
        this.message = message;
    }

    public String getStatus() {
        return status;
    }

    public String getMessage() {
        return message;
    }
}
