package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums;

/**
 * 优惠券类别枚举类, 10=定额现金券（满减）, 50=满折券， 40=提货券
 * @author: li.jundong
 * @date: 2019/6/26 14:48
 */
public enum CouponCategoryEnum {


    QUOTA_CASH(10, "定额现金券"),

    EXTRACT(40, "提货券"),

    DISCOUNT(50, "满折券"),
    PIECE_GIF(60, "满赠券")
    ;

    private Integer category;

    private String describe;

    CouponCategoryEnum(Integer category, String describe) {
        this.category = category;
        this.describe = describe;
    }

    public Integer getCategory() {
        return category;
    }

    public String getDescribe() {
        return describe;
    }

    /**
     * 根据枚举值查找枚举类
     * @author: li.jundong
     * @date: 2019/6/26 14:44
     * @param: * @param status
     * @return:com.dtyunxi.yundt.cube.biz.marketing.enums.CouponCategoryEnum
     */
    public static CouponCategoryEnum findEnum(Integer category){
        if(null == category){
            return null;
        }
        for(CouponCategoryEnum typeEnum: values()){
            if(typeEnum.getCategory().equals(category)){
                return typeEnum;
            }
        }
        return null;
    }
}
