package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums;


import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.IExceptionEnum;

/**
 * 优惠券模板异常枚举类
 * @author li.jundong
 * @date: 2019/6/26 16:33
 */
public enum CouponErrorEnum implements IExceptionEnum {

    /**
     * 参数不存在
     */
    PARAMS_EXIST("1400", "参数不存在"),

    /**
     * 批量生成优惠券系统繁忙
     */
    COUPON_BATCH_CREATE_SYSTEM_BUSY("1401", "批量生成优惠券系统繁忙"),

    /**
     * 尚未到领取优惠券时间
     */
    COUPON_RECEIVE_START_TIME_BEFORE("1402", "尚未到领取优惠券时间"),

    /**
     * 领取优惠券时间已结束
     */
    COUPON_RECEIVE_END_TIME_AFTER("1403", "领取优惠券时间已结束"),

    /**
     * 领取优惠券已达上限
     */
    COUPON_RECEIVE_TO_MAX("1404", "领取该优惠券数量已达上限"),

    /**
     * 优惠券已被抢光
     */
    COUPON_RECEIVE_OUT("1405", "优惠券已被抢光"),

    /**
     * 优惠券批次号不存在
     */
    COUPON_BATCH_NO_EXIST("1406", "优惠券批次号不存在"),

    /**
     * 优惠券不存在
     */
    COUPON_NOT_EXIST("1407", "优惠券不存在"),

    /**
     * 优惠券信息错误
     */
    COUPON_INFO_ERROR("1408", "优惠券信息错误"),

    /**
     * 优惠券锁定失败
     */
    COUPON_LOCK_FAIL("1409", "优惠券锁定失败"),

    /**
     * 优惠券批次号生成数量不存在
     */
    COUPON_BATCH_GENERATE_NUM_NO_EXIST("1409", "优惠券批次号生成数量不存在"),

    /**
     * 优惠券状态不正确
     */
    COUPON_STATUS_ERROR("1410", "优惠券状态不正确"),

    /**
     * 优惠券尚未生效
     */
    COUPON_NOT_EFFECTIVE("1411", "优惠券尚未生效"),

    /**
     * 优惠券已失效
     */
    COUPON_INVALID("1412", "优惠券已失效"),

    /**
     * 参数不正确
     */
    COUPON_PARAMES_ERROR("1413", "参数不正确"),

    /**
     * 券支付编号不正确
     */
    COUPON_PAYMENT_CODE_ERROR("1414", "券支付编号不正确"),

    /**
     * 券使用总览统计请求BI统计出现异常
     */
    COUPON_STATISTIC_REQUEST_BI_ERROR("1415", "券使用总览统计请求BI统计出现异常"),

    /**
     * 请求超时
     */
    COUPON_TIME_OUT_ERROR("1416", "请求超时"),

    /**
     * 该优惠券属于定向券
     */
    COUPON_IS_DIRECT("1417", "该优惠券属于定向券，当前用户不能使用"),

    /**
     * 该订单号的优惠券已发放
     */
    OUTER_ORDER_CODE_IS_EXIST("1418", "该订单号的优惠券已发放"),

    /**
     * 每日领取优惠券已达上限
     */
    COUPON_DAY_RECEIVE_TO_MAX("1419", "每日领取该优惠券数量已达上限"),

    /**
     * 系统错误
     */
    SYSTEM_ERROR("500", "系统错误"),

    /**
     * 中台报错
     */
    CUBE_ERROR("5000", "中台报错"),

    POINT_NOT_ENOGH("1420", "积分不足"),
    ;

    private String code;

    private String message;

    CouponErrorEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getMsg() {
        return message;
    }
}
