package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums;

/**
 * 券使用总览导出类型
 *
 * @author 浮云
 */
public enum CouponExportTypeEnum {

    COUPON_NUM("1", "coupon/amount/export", "销售量/发放量"),
    SKU("2", "coupon/sku/export", "SKU畅销排行"),
    CHANNEL("3", "coupon/channel/export", "渠道核销占比"),
    SHOP("4", "coupon/shop/export", "门店核销排行");

    CouponExportTypeEnum(String type, String url, String describe) {
        this.type = type;
        this.url = url;
        this.describe = describe;
    }

    public static String getUrl(String type) {
        for (CouponExportTypeEnum typeEnum : values()) {
            if (typeEnum.getType().equals(type)) {
                return typeEnum.getUrl();
            }
        }
        return null;
    }

    private String type;

    private String url;

    private String describe;

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDescribe() {
        return describe;
    }

    public void setDescribe(String describe) {
        this.describe = describe;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}
