package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * 优惠券使用层级, 10=订单电子券, 20=品类电子券, 30=商品电子券, 40=店铺电子券, 50=通用使用层级
 * @author li.jundong
 * @date: 2019/6/26 15:18
 */
public enum CouponHierarchyEnum {

    ORDER("10", "订单电子券"),

    CATEGORY("20", "品类电子券"),

    ITEM("30", "商品电子券"),

    SHOP("40", "店铺电子券"),

    GENERAL("50", "通用使用层级")

    ;

    private String hierarchy;

    private String describe;

    CouponHierarchyEnum(String hierarchy, String describe) {
        this.hierarchy = hierarchy;
        this.describe = describe;
    }

    public String getHierarchy() {
        return hierarchy;
    }

    public String getDescribe() {
        return describe;
    }

    /**
     * 根据枚举值查找枚举类
     * @author: li.jundong
     * @date: 2019/6/26 14:44
     * @param: * @param status
     * @return:com.dtyunxi.yundt.cube.biz.marketing.enums.CouponHierarchyEnum
     */
    public static CouponHierarchyEnum findEnum(String hierarchy){
        if(StringUtils.isBlank(hierarchy)){
            return null;
        }
        for(CouponHierarchyEnum hierarchyEnum: values()){
            if(hierarchyEnum.getHierarchy().equals(hierarchy)){
                return hierarchyEnum;
            }
        }
        return null;
    }

    /**
     * 转换为标品枚举值
     * @author li.jundong
     * @date 2019/7/11
     * @param hierarchy
     * @return java.lang.String
     */
    public static String convertBestoreEnum(String hierarchy){
        //使用层级 使用层级 X-订单电子券 Y-品类券 留空-商品电子券
        String cpnlevel = null;
        CouponHierarchyEnum couponHierarchyEnum = findEnum(hierarchy);
        switch (couponHierarchyEnum){
            case ORDER:
                cpnlevel = "X";
                break;
            case CATEGORY:
                cpnlevel = "Y";
                break;
            case ITEM:
                cpnlevel = "";
                break;
        }
        return cpnlevel;
    }

    /**
     * 转换为中心枚举类
     * @author li.jundong
     * @date 2019/7/12
     * @param cpnLevel
     * @return java.lang.String
     */
    public static String convertEnum(String cpnLevel){
        if("".equals(cpnLevel)){
            return ITEM.getHierarchy();
        }else if("X".equals(cpnLevel)){
            return ORDER.getHierarchy();
        }else if("Y".equals(cpnLevel)){
            return CATEGORY.getHierarchy();
        }
        return null;
    }
}
