package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums;

/**
 * 优惠券互斥规则枚举类, 10=不限制互斥, 20=与所有券互斥, 30=与订单级电子券互斥, 40=与商品级电子券互斥  50=与平台券互斥，60=与店铺券互斥
 * @author li.jundong
 * @date: 2019/7/1 11:08
 */
public enum CouponMutexTypeEnum {

    NO_MUTEX(10, "不限制互斥"),

    ALL_MUTEX(20, "与所有券互斥"),

    ORDER_COUPON_MUTEX(30, "与订单级电子券互斥"),

    ITEM_COUPON_MUTEX(40, "与商品级电子券互斥"),

    PLATFORM_COUPON_MUTEX(50, "与平台券互斥"),

    SHOP_COUPON_MUTEX(60, "与店铺券互斥");

    Integer mutex;

    String describe;

    CouponMutexTypeEnum(Integer mutex, String describe) {
        this.mutex = mutex;
        this.describe = describe;
    }

    public Integer getMutex() {
        return mutex;
    }

    public String getDescribe() {
        return describe;
    }

    /**
     * 根据枚举值查找枚举类
     * @author: li.jundong
     * @date: 2019/6/26 14:44
     * @param: * @param status
     * @return:com.dtyunxi.yundt.cube.biz.marketing.enums.CouponMutexTypeEnum
     */
    public static CouponMutexTypeEnum findEnum(Integer mutex){
        if(mutex == null){
            return null;
        }
        for(CouponMutexTypeEnum e: values()){
            if(e.getMutex().equals(mutex)){
                return e;
            }
        }
        return null;
    }
}
