package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums;

/**
 * 优惠券状态枚举类
 *
 * @author 浮云
 */
public enum CouponPackStatusEnum {

    //券状态，10-已创建，20-已核销，30-已作废，40-未领取，50-冻结 （与原中台状态机统一）

    STOP(0, "停用"),
    ACTIVATE(1, "已激活");

    private Integer status;

    private String description;

    CouponPackStatusEnum(Integer status, String description) {
        this.status = status;
        this.description = description;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * 根据状态查询枚举
     *
     * @param status
     * @return
     */
    public static CouponPackStatusEnum getByStatus(Integer status) {
        if(null == status){
            return null;
        }
        for (CouponPackStatusEnum couponStatusEnum : values()) {
            if (couponStatusEnum.getStatus().equals(status)) {
                return couponStatusEnum;
            }
        }
        return null;
    }
}
