package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums;


import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.IExceptionEnum;

/**
 * 优惠券模板异常枚举类
 * @author li.jundong
 * @date: 2019/6/26 16:33
 */
public enum CouponTemplateErrorEnum implements IExceptionEnum {

    /**
     * 参数不存在
     */
    PARAMS_EXIST("1300", "参数不存在"),

    /**
     * 优惠券模板不存在
     */
    COUPON_TEMPLATE_EXIST("1301", "优惠券模板不存在"),

    /**
     * 优惠券结束时间不存在
     */
    INVALIDTIME_EXIST("1302", "优惠券结束时间不存在"),

    /**
     * 新失效时间比原来的失效时间早，请重新输入
     */
    INVALIDTIME_BEFORE("1303", "新失效时间比原来的失效时间早，请重新输入"),

    /**
     * 优惠券模板状态不存在
     */
    COUPON_TEMPLATE_STATUS_EXIST("1304", "优惠券模板状态不存在"),

    /**
     * 优惠券模板状态已是作废状态
     */
    COUPON_TEMPLATE_STATUS_ALREADY_INVALID("1305", "优惠券模板状态已是作废状态"),

    /**
     * 优惠券库存不足
     */
    COUPON_TEMPLATE_STOCK_INSUFFICIENT("1306", "优惠券库存不足"),

    /**
     * 优惠券状态错误
     */
    COUPON_TEMPLATE_STATUS_ERROR("1307", "优惠券模板[{0}]不是{1}状态"),

    /**
     * 优惠券模板可用库存不存在
     */
    COUPON_TEMPLATE_STOCK_EXIST("1308", "优惠券模板可用库存不存在"),

    /**
     * 动态日期配置的优惠券不能延期
     */
    COUPON_TEMPLATE_DYNAMIC_DATE_NOT_DELAY("1309", "动态日期配置的优惠券不能延期"),

    /**
     * 优惠券模板为非激活状态
     */
    COUPON_TEMPLATE_NOT_ACTIVATE("1310", "优惠券模板为非激活状态"),

    /**
     * 优惠券模板编码不存在
     */
    COUPON_TEMPLATE_CODE_EXIST("1311", "优惠券模板编码不存在"),

    /**
     * 券模板对应可领取券数量
     */
    ENGINE_CONFIG_ERR("1312", "领取限制未配置"),

    /**
     * 缺少参数
     */
    PARAMS_LACK("1313", "缺少参数"),

    /**
     * 优惠券模板同步错误
     */
    COUPON_TEMPLATE_SYNC_ERROR("1314", "优惠券模板同步错误, {0}"),

    /**
     * 优惠券模板不能生成券码
     */
    COUPON_TEMPLATE_CANNOT_GENERATECODE("1315", "优惠券模板不能生成券码"),

    /**
     * 该优惠券模板为预生成券类型，不能发券
     */
    COUPON_IS_GENERATE_TYPE("1316", "该优惠券模板为预生成券类型，不能发券"),

    /**
     * 优惠券模板[xxx]已过期
     */
    COUPON_TEMPLATE_BATCH_ACTIVE_EXPIRE("1317", "优惠券模板[{0}]已过期"),

    /**
     * 优惠券模板已过期
     */
    COUPON_TEMPLATE_IS_EXPIRE("1318", "优惠券模板已过期"),

    /**
     * 优惠券模板未生效
     */
    COUPON_TEMPLATE_IS_NOT_EFFECTED("1319", "优惠券模板未生效"),

    /**
     * 优惠券可领取数量不足
     */
    OUPON_TEMPLATE_RECEIVE_NUM_INSUFFICIENT("1320", "优惠券可领取数量不足"),

    /**
     * 优惠券有效期类型不能变更
     */
    OUPON_TEMPLATE_VALIDITY_TYPE_NO_CHANGE("1321", "优惠券有效期类型不能变更"),

    /**
     * 优惠券模板关联到营销活动不存在
     */
    OUPON_TEMPLATE_SOURCE_CODE_NO_EXIST("1322", "优惠券模板关联到营销活动不存在"),

    /**
     * 批次正在生成
     */
    COUPON_IS_GENERATING("1323", "优惠券模板有正在生成的批次"),

    /**
     * 优惠券尚未到领取开始时间
     */
    COUPON_BEFORE_RECEIVE_START_TIME("1324", "优惠券尚未到领取开始时间"),

    /**
     * 优惠券领取结束时间已过
     */
    COUPON_AFTER_RECEIVE_END_TIME("1325", "优惠券领取结束时间已过"),
    ;

    private String code;

    private String message;

    CouponTemplateErrorEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getMsg() {
        return message;
    }
}
