package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums;

/**
 * 优惠券模板用途归类枚举类, 10=售后安抚, 20=会员活动, 21=会员维护, 22=会员福利, 30=客商团购, 40=主题促销H5游戏, 41=新店开业/老店店庆, 42=异业合作, 43=地推活动, 44=商品活动, 50=其它
 * @author: li.jundong
 * @date: 2019/6/26 15:05
 */
public enum CouponTemplatePurposeEnum {

    AFTER_SALE(10, "售后安抚"),

    MEMBER_ACTIVITY(20, "会员活动"),

    MEMBER_MAINTAIN(21, "会员维护"),

    MEMBER_WELFARE(22, "会员福利"),

    GUEST_GROUP(30, "客商团购"),

    H5_GAME(40, "主题促销H5游戏"),

    SHOP_CELEBRATE(41, "新店开业/老店店庆"),

    THIRD_COOPERATION(42, "异业合作"),

    EXTENSION_ACTIVITY(43, "地推活动"),

    ITEM_ACTIVITY(44, "商品活动"),

    OTHER(50, "其他"),

    WX_UNION_ACTIVITY(60, "微信联合活动"),

    DXDP_INTERFACE(61, "大众点评接口"),

    ;

    private Integer purpose;

    private String describe;

    CouponTemplatePurposeEnum(Integer purpose, String describe) {
        this.purpose = purpose;
        this.describe = describe;
    }

    public Integer getPurpose() {
        return purpose;
    }

    public String getDescribe() {
        return describe;
    }

    /**
     * 根据枚举值查找枚举类
     * @author: li.jundong
     * @date: 2019/6/26 14:44
     * @param: * @param status
     * @return:com.dtyunxi.yundt.cube.biz.marketing.enums.CouponTemplatePurposeEnum
     */
    public static CouponTemplatePurposeEnum findEnum(Integer purpose){
        if(purpose == null){
            return null;
        }
        for(CouponTemplatePurposeEnum purposeEnum: values()){
            if(purposeEnum.getPurpose().equals(purpose)){
                return purposeEnum;
            }
        }
        return null;
    }
}
