package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums;

/**
 * 优惠券模板适用店铺枚举类, 10=所有店铺, 20=线上店铺, 30=线下店铺, 40=自定义店铺, 50=商城券
 * @author li.jundong
 * @date: 2019/7/1 11:08
 */
public enum CouponTemplateShopTypeEnum {

    ALL_SHOP(10, "所有店铺"),

    ONLINE_SHOP(20, "线上店铺"),

    OFFLINE_SHOP(30, "线下店铺"),

    CUSTOM_SHOP(40, "自定义店铺"),

    MARKET(50, "商城券"),

    INCLUDE_PART_SHOP(60, "部分店铺"),

    EXCLUDE_PART_SHOP(70, "排除部分店铺")
            ;
    Integer type;

    String describe;

    CouponTemplateShopTypeEnum(Integer type, String describe) {
        this.type = type;
        this.describe = describe;
    }

    public Integer getType() {
        return type;
    }

    public String getDescribe() {
        return describe;
    }

    /**
     * 根据枚举值查找枚举类
     * @author: li.jundong
     * @date: 2019/6/26 14:44
     * @param: * @param status
     * @return:com.dtyunxi.yundt.cube.biz.marketing.enums.CouponTemplateShopTypeEnum
     */
    public static CouponTemplateShopTypeEnum findEnum(Integer type){
        if(null == type){
            return null;
        }
        for(CouponTemplateShopTypeEnum e: values()){
            if(e.getType().equals(type)){
                return e;
            }
        }
        return null;
    }
}
