package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * 优惠券模板状态枚举类, 10=已创建, 20=已启用, 30=已停用, 40=已作废
 *
 * @author: li.jundong
 * @date: 2019/6/26 14:35
 */
public enum CouponTemplateStatusEnum {

    CREATE("10", "已创建"),

    ACTIVATE("20", "已启用"),

    STOP("30", "已停用"),

    INVALID("40", "已作废"),
    ;

    private String status;

    private String describe;

    CouponTemplateStatusEnum(String status, String describe) {
        this.status = status;
        this.describe = describe;
    }

    public String getStatus() {
        return status;
    }

    public String getDescribe() {
        return describe;
    }

    /**
     * 根据枚举值查找枚举类
     * @author: li.jundong
     * @date: 2019/6/26 14:44
     * @param: * @param status
     * @return:com.dtyunxi.yundt.cube.biz.marketing.enums.CouponTemplateStatusEnum
     */
    public static CouponTemplateStatusEnum findEnum(String status){
        if(StringUtils.isBlank(status)){
            return null;
        }
        for(CouponTemplateStatusEnum statusEnum: values()){
            if(statusEnum.getStatus().equals(status)){
                return statusEnum;
            }
        }
        return null;
    }
}
