package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums;

/**
 * 0=个性化商品
 * 1=个性化折扣
 * 2=个性化有效期
 * 3=个性化商品 + 个性化折扣
 * 4=个性化商品 + 个性化有效期
 * 5=个性化折扣 + 个性化有效期
 * 6=个性化商品 + 个性化折扣 + 个性化有效期
 * 7=个性化最低消费金额
 * 8=个性化面额
 */
public enum PersonalizedTypeEnum {

    PERSON_ITEM(0, "个性化商品"),

    PERSON_DISCOUNT(1, "个性化折扣"),

    PERSON_DATE(2, "个性化有效期"),

    PERSON_ITEM_DISCOUNT(3, "个性化商品 + 个性化折扣"),

    PERSON_ITEM_DATE(4, "个性化商品 + 个性化有效期"),

    PERSON_DISCOUNT_DATE(5, "个性化折扣 + 个性化有效期"),

    PERSON_ITEM_DISCOUNT_DATE(6, "个性化商品 + 个性化折扣 + 个性化有效期"),
    PERSON_LEAS_PAY(7, "个性化最低消费金额"),
    PERSON_COUPON_COUNT(8, "个性化面额");

    private Integer type;

    private String describe;

    PersonalizedTypeEnum(Integer type, String describe) {
        this.type = type;
        this.describe = describe;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getDescribe() {
        return describe;
    }

    /**
     * 根据枚举值查找枚举类
     * @author: li.jundong
     * @date: 2019/6/26 14:44
     * @param: * @param status
     * @return:com.dtyunxi.yundt.cube.biz.marketing.enums.CouponTypeEnum
     */
    public static PersonalizedTypeEnum findEnum(Integer type){
        if(null == type){
            return null;
        }
        for(PersonalizedTypeEnum typeEnum: values()){
            if(typeEnum.getType().equals(type)){
                return typeEnum;
            }
        }
        return null;
    }
}
