package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request;

import com.alibaba.fastjson.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 批量发放优惠券dto
 *
 * @author 浮云
 */
@ApiModel(
        value = "CouponBatchSendReqDto",
        description = "批量发放优惠券dto"
)
public class CouponBatchSendReqDto implements Serializable {

    @ApiModelProperty(name = "templates", value = "优惠券模板信息")
    private List<CouponSendTemplateReqDto> templates;

    @ApiModelProperty(name = "memberIds", value = "发放的会员id集合")
    private List<Long> memberIds;

    @ApiModelProperty(name = "activityCode", value = "活动编号, 记录小程序领券时的营销活动id、营销定向推券的活动id、app领券时记录app后台的活动编号、储值赠礼的营销活动id")
    private String activityCode;

    @ApiModelProperty(name = "channel", value = "券领取渠道")
    private String channel;

    @ApiModelProperty(name = "outerOrderCode", value = "外部订单号，如淘宝订单号")
    private String outerOrderCode;

    @ApiModelProperty(name = "returnSucess", value = "是否返回成功信息，0-不返回，1-返回，默认0")
    private Integer returnSucess;

    @ApiModelProperty(name = "isValidate", value = "是否校验小程序推券列表到可领取数量")
    private boolean isValidate;

    @ApiModelProperty(name = "checkPointCode", value = "检查点编码：发券默认是 IC_RECEIVE_COUPON ")
    private String checkPointCode;


    public List<CouponSendTemplateReqDto> getTemplates() {
        return templates;
    }

    public CouponBatchSendReqDto() {
    }

    public CouponBatchSendReqDto(List<CouponSendTemplateReqDto> templates, List<Long> memberIds) {
        this.templates = templates;
        this.memberIds = memberIds;
    }

    public CouponBatchSendReqDto(List<CouponSendTemplateReqDto> templates, List<Long> memberIds, Integer returnSucess) {
        this.templates = templates;
        this.memberIds = memberIds;
        this.returnSucess = returnSucess;
    }

    public CouponBatchSendReqDto(List<CouponSendTemplateReqDto> templates, List<Long> memberIds, Integer returnSucess, String channel, String outerOrderCode) {
        this.templates = templates;
        this.memberIds = memberIds;
        this.returnSucess = returnSucess;
        this.channel = channel;
        this.outerOrderCode = outerOrderCode;
    }

    public Integer getReturnSucess() {
        return returnSucess;
    }

    public void setReturnSucess(Integer returnSucess) {
        this.returnSucess = returnSucess;
    }

    public void setTemplates(List<CouponSendTemplateReqDto> templates) {
        this.templates = templates;
    }

    public List<Long> getMemberIds() {
        return memberIds;
    }

    public void setMemberIds(List<Long> memberIds) {
        this.memberIds = memberIds;
    }

    public String getActivityCode() {
        return activityCode;
    }

    public void setActivityCode(String activityCode) {
        this.activityCode = activityCode;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getOuterOrderCode() {
        return outerOrderCode;
    }

    public void setOuterOrderCode(String outerOrderCode) {
        this.outerOrderCode = outerOrderCode;
    }

    public boolean getIsValidate() {
        return isValidate;
    }

    public void setIsValidate(boolean validate) {
        isValidate = validate;
    }

    public String getCheckPointCode() {
        return checkPointCode;
    }

    public void setCheckPointCode(String checkPointCode) {
        this.checkPointCode = checkPointCode;
    }

    public static void main(String[] args) {
        List<Long> memberIds = new ArrayList<>();
        memberIds.add(1212980625929744416L);
        memberIds.add(1213005265422069870L);
        List<CouponSendTemplateReqDto> templates = new ArrayList<>();
        CouponSendTemplateReqDto templateReqDto1 = new CouponSendTemplateReqDto();
        templateReqDto1.setCouponTemplateId(1212907782051237988L);
        templateReqDto1.setSendNum(2);

        CouponSendTemplateReqDto templateReqDto2 = new CouponSendTemplateReqDto();
        templateReqDto2.setCouponTemplateId(1212983588195700813L);
        templateReqDto2.setSendNum(2);

        templates.add(templateReqDto1);
        templates.add(templateReqDto2);

        CouponBatchSendReqDto couponBatchSendReqDto = new CouponBatchSendReqDto();
        couponBatchSendReqDto.setMemberIds(memberIds);
        couponBatchSendReqDto.setTemplates(templates);
        System.out.println(JSON.toJSONString(couponBatchSendReqDto));
    }
}
