/**
 * @(#) CouponCreateReqDto.java 1.0 2018-10-24
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request;

import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActionReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ConditionReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.AuditStatusEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 优惠券活动创建Dto
 *
 * @author 魄罗
 * @since 2.0.0
 */
@ApiModel(value = "CouponCreateReqDto", description = "优惠券活动创建Dto")
public class CouponCreateReqDto extends RequestDto {
    private static final long serialVersionUID = -1776454242942280177L;
    /**
     * 优惠券编码
     */
    @ApiModelProperty(name = "couponCode", value = "优惠券编码")
    @NotNull
    private String couponCode;
    /**
     * 优惠券名称
     */
    @ApiModelProperty(name = "couponName", value = "优惠券名称")
    @NotNull
    private String couponName;
    /**
     * 说明
     */
    @ApiModelProperty(name = "remark", value = "说明")
    private String remark;
    /**
     * 渠道，ONLINE：线上渠道，OFFLINE：线下渠道
     */
    @ApiModelProperty(name = "channel", value = "渠道，ONLINE：线上渠道，OFFLINE：线下渠道")
    @NotNull
    private String channel;
    /**
     * 状态，DRAFT：草稿、HAS_CONSUMED：待审核、AUDIT_PASS：审核通过、FREEZE：驳回
     */
    @ApiModelProperty(name = "couponDefineStatus", value = "状态，DRAFT：草稿、HAS_CONSUMED：待审核、AUDIT_PASS：审核通过、FREEZE：驳回")
    @NotNull
    private String couponDefineStatus;
    /**
     * 发放总数量
     */
    @ApiModelProperty(name = "totalIssueQuantity", value = "发放总数量")
    @NotNull
    private Long totalIssueQuantity;

    /**
     * 优惠券金额阀值
     */
    @ApiModelProperty(name = "amount", value = "优惠券金额阀值")
    @NotNull
    private BigDecimal amount;

    /**
     * 领取开始时间
     */
    @ApiModelProperty(name = "receiveStartTime", value = "领取开始时间")
    private Date receiveStartTime;
    /**
     * 领取截止时间
     */
    @ApiModelProperty(name = "receiveEndTime", value = "领取截止时间")
    private Date receiveEndTime;
    /**
     * 开始时间
     */
    @ApiModelProperty(name = "beginTime", value = "活动开始时间")
    private Date beginTime;
    /**
     * 结束时间
     */
    @ApiModelProperty(name = "endTime", value = "活动结束时间")
    private Date endTime;

    /**
     * 优惠券使用开始时间
     */
    @ApiModelProperty(name = "couponUseBeginTime", value = "优惠券使用开始时间")
    private Date couponUseBeginTime;
    /**
     * 优惠券使用结束时间
     */
    @ApiModelProperty(name = "couponUseEndTime", value = "优惠券使用结束时间")
    private Date couponUseEndTime;

    /**
     * 面值（单位：元或百分比）
     */
    @ApiModelProperty(name = "couponValue", value = "面值（单位：元或百分比）")
    @NotNull
    private BigDecimal couponValue;
    /**
     * 券类型，现金券：CASH，折扣券：DISCOUNT
     */
    @ApiModelProperty(name = "couponType", value = "券类型，现金券：CASH，折扣券：DISCOUNT")
    @NotNull
    private String couponType;
    /**
     * 是否生成券编码（Y：是、N：否，默认N）
     */
    @ApiModelProperty(name = "isGenerateCode", value = "是否生成券编码（Y：是、N：否）")
    private String isGenerateCode = "N";
    /**
     * 是否允许叠加使用（Y：是、N：否）
     */
    @ApiModelProperty(name = "isCanSuperimposed", value = "是否允许叠加使用（Y：是、N：否）")
    @NotNull
    private String isCanSuperimposed;
    /**
     * 是否预生成（提前生成优惠券）
     */
    @ApiModelProperty(name = "isGenerate", value = "是否预生成（提前生成优惠券）")
    private String isGenerate = "N";

    /**
     * 扩展字段存放JSON
     */
    @ApiModelProperty(name = "extension", value = "扩展字段存放JSON")
    private String extension;
    /**
     * 活动状态（ENABLE：启用、DISABLE：禁用、ACTIVITYING：活动中、TIMEOUT：暂停、FINISH：活动结束）
     */
    @ApiModelProperty(name = "activityStatus", value = "活动状态（NEW：新建、DISABLE：禁用、READY：就绪、ACTIVATE：活动中、TIMEOUT：暂停、FINISH：活动结束）")
    private ActivityStatusEnum activityStatusEnum;
    /**
     * 审核状态（NEW：新建、WAIT_AUDIT：待审核、AUDIT_PASS：审核通过、AUDIT_REFUSE：审核不通过）
     */
    @ApiModelProperty(name = "auditStatus", value = "审核状态（NEW：新建、WAIT_AUDIT：待审核、AUDIT_PASS：审核通过、AUDIT_REFUSE：审核不通过）")
    private AuditStatusEnum auditStatusEnum;


    /**
     * 定时执行表达式（quartz表达式）
     */
    @ApiModelProperty(name = "execExpression", value = "定时执行表达式（quartz表达式）")
    private String execExpression;
    /**
     * 活动模版编号
     */
    @ApiModelProperty(name = "activityTemplateId", value = "活动模版编号")
    private Long activityTemplateId;
    /**
     * 预告时间（不为空，则调用预告逻辑，由定制实现）
     */
    @ApiModelProperty(name = "noticeTime", value = "预告时间（不为空，则调用预告逻辑，由定制实现）")
    private Date noticeTime;
    /**
     * 活动商品
     */
    @ApiModelProperty(name = "activityItems", value = "活动商品")
    private List<CouponItemReqDto> activityItems;
    /**
     * 活动条件实例
     */
    @ApiModelProperty(name = "conditions", value = "活动条件实例")
    private List<ConditionReqDto> conditions;
    /**
     * 活动动作实例
     */
    @ApiModelProperty(name = "actions", value = "活动动作实例")
    private List<ActionReqDto> actions;

    /**
     * 商品使用范围（SELLER：商户、SHOP：店铺、CATEGORY：类目、ITEM：商品）
     */
    @ApiModelProperty(name = "itemRange", value = "商品使用范围（SELLER：商户、SHOP：店铺、CATEGORY：类目、ITEM：商品）")
    private String itemRange;

    /**
     * 活动参与人
     */
    @ApiModelProperty(name = "userIds", value = "活动参与人")
    private List<Long> userIds;


    @ApiModelProperty(name = "sellerId", value = "商户ID")
    private Long sellerId;

    @ApiModelProperty(name = "shopId", value = "店铺ID")
    private Long shopId;


    public List<Long> getUserIds() {
        return userIds;
    }

    public void setUserIds(List<Long> userIds) {
        this.userIds = userIds;
    }

    public String getCouponCode() {
        return couponCode;
    }

    public void setCouponCode(String couponCode) {
        this.couponCode = couponCode;
    }

    public String getCouponName() {
        return couponName;
    }

    public void setCouponName(String couponName) {
        this.couponName = couponName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getCouponDefineStatus() {
        return couponDefineStatus;
    }

    public void setCouponDefineStatus(String couponDefineStatus) {
        this.couponDefineStatus = couponDefineStatus;
    }

    public Long getTotalIssueQuantity() {
        return totalIssueQuantity;
    }

    public void setTotalIssueQuantity(Long totalIssueQuantity) {
        this.totalIssueQuantity = totalIssueQuantity;
    }

    public Date getReceiveStartTime() {
		return receiveStartTime;
	}

	public void setReceiveStartTime(Date receiveStartTime) {
		this.receiveStartTime = receiveStartTime;
	}

	public Date getReceiveEndTime() {
		return receiveEndTime;
	}

	public void setReceiveEndTime(Date receiveEndTime) {
		this.receiveEndTime = receiveEndTime;
	}

	public Date getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setNoticeTime(Date noticeTime) {
        this.noticeTime = noticeTime;
    }

    public BigDecimal getCouponValue() {
        return couponValue;
    }

    public void setCouponValue(BigDecimal couponValue) {
        this.couponValue = couponValue;
    }

    public String getCouponType() {
        return couponType;
    }

    public void setCouponType(String couponType) {
        this.couponType = couponType;
    }

    public String getIsGenerateCode() {
        return isGenerateCode;
    }

    public void setIsGenerateCode(String isGenerateCode) {
        this.isGenerateCode = isGenerateCode;
    }

    public String getIsCanSuperimposed() {
        return isCanSuperimposed;
    }

    public void setIsCanSuperimposed(String isCanSuperimposed) {
        this.isCanSuperimposed = isCanSuperimposed;
    }

    public String getIsGenerate() {
        return isGenerate;
    }

    public void setIsGenerate(String isGenerate) {
        this.isGenerate = isGenerate;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getExecExpression() {
        return execExpression;
    }

    public void setExecExpression(String execExpression) {
        this.execExpression = execExpression;
    }

    public Long getActivityTemplateId() {
        return activityTemplateId;
    }

    public void setActivityTemplateId(Long activityTemplateId) {
        this.activityTemplateId = activityTemplateId;
    }

    public Date getNoticeTime() {
        return noticeTime;
    }

    public List<CouponItemReqDto> getActivityItems() {
        return activityItems;
    }

    public void setActivityItems(List<CouponItemReqDto> activityItems) {
        this.activityItems = activityItems;
    }

    public ActivityStatusEnum getActivityStatusEnum() {
        return activityStatusEnum;
    }

    public void setActivityStatusEnum(ActivityStatusEnum activityStatusEnum) {
        this.activityStatusEnum = activityStatusEnum;
    }

    public AuditStatusEnum getAuditStatusEnum() {
        return auditStatusEnum;
    }

    public void setAuditStatusEnum(AuditStatusEnum auditStatusEnum) {
        this.auditStatusEnum = auditStatusEnum;
    }

    public List<ConditionReqDto> getConditions() {
        return conditions;
    }

    public void setConditions(List<ConditionReqDto> conditions) {
        this.conditions = conditions;
    }

    public List<ActionReqDto> getActions() {
        return actions;
    }

    public void setActions(List<ActionReqDto> actions) {
        this.actions = actions;
    }

    public String getItemRange() {
        return itemRange;
    }

    public void setItemRange(String itemRange) {
        this.itemRange = itemRange;
    }

    public Date getCouponUseBeginTime() {
        return couponUseBeginTime;
    }

    public void setCouponUseBeginTime(Date couponUseBeginTime) {
        this.couponUseBeginTime = couponUseBeginTime;
    }

    public Date getCouponUseEndTime() {
        return couponUseEndTime;
    }

    public void setCouponUseEndTime(Date couponUseEndTime) {
        this.couponUseEndTime = couponUseEndTime;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }
}
