package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 优惠券查询dto
 * @author li.jundong
 * @date: 2019/6/21 16:21
 */
@ApiModel(
        value = "CouponExportReqDto",
        description = "优惠券查询dto"
)
public class CouponExtReqDto extends RequestDto {

    @ApiModelProperty(
            name = "couponTemplateId",
            value = "优惠券模板id"
    )
    @NotNull
    private Long couponTemplateId;

    @ApiModelProperty(
            name = "couponCode",
            value = "优惠券编码"
    )
    private String couponCode;

    @ApiModelProperty(
            name = "mobile",
            value = "绑定手机号"
    )
    private String mobile;

    @ApiModelProperty(name = "userId", value = "券归属人")
    private Long userId;

    @ApiModelProperty(
            name = "couponStatus",
            value = "券状态，10-已创建，40-已领取，20-已核销，30-已作废"
    )
    private String couponStatus;

    @ApiModelProperty(
            name = "batchNo",
            value = "导出批次号"
    )
    private String batchNo;

    @ApiModelProperty(
            name = "couponCodes",
            value = "券码集合"
    )
    private List<String> couponCodes;

    //升序字段,多个字段时逗号隔开
    private String orderBy;

    //降序字段,多个字段时逗号隔开
    private String orderByDesc;

    public Long getCouponTemplateId() {
        return couponTemplateId;
    }

    public void setCouponTemplateId(Long couponTemplateId) {
        this.couponTemplateId = couponTemplateId;
    }

    public String getCouponCode() {
        return couponCode;
    }

    public void setCouponCode(String couponCode) {
        this.couponCode = couponCode;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getCouponStatus() {
        return couponStatus;
    }

    public void setCouponStatus(String couponStatus) {
        this.couponStatus = couponStatus;
    }

    public String getBatchNo() {
        return batchNo;
    }

    public void setBatchNo(String batchNo) {
        this.batchNo = batchNo;
    }

    public List<String> getCouponCodes() {
        return couponCodes;
    }

    public void setCouponCodes(List<String> couponCodes) {
        this.couponCodes = couponCodes;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getOrderBy() {
        return orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public String getOrderByDesc() {
        return orderByDesc;
    }

    public void setOrderByDesc(String orderByDesc) {
        this.orderByDesc = orderByDesc;
    }
}
