package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 优惠券转赠dto
 *
 * @author 浮云
 */
@ApiModel(
        value = "CouponUseReqDto",
        description = "优惠券转赠dto"
)
public class CouponGifReqDto implements Serializable {

    @ApiModelProperty(name = "sourceMemberId", value = "源会员id")
    private Long sourceMemberId;
    @ApiModelProperty(name = "sourcePhone", value = "源会员手机号")
    private String sourcePhone;

    @ApiModelProperty(name = "targetMemberId", value = "目标会员id")
    private Long targetMemberId;
    @ApiModelProperty(name = "targetPhone", value = "目标会员手机号")
    private String targetPhone;

    @ApiModelProperty(name = "couponCode", value = "优惠券券码")
    @NotNull
    private String couponCode;

    public Long getSourceMemberId() {
        return sourceMemberId;
    }

    public void setSourceMemberId(Long sourceMemberId) {
        this.sourceMemberId = sourceMemberId;
    }

    public Long getTargetMemberId() {
        return targetMemberId;
    }

    public void setTargetMemberId(Long targetMemberId) {
        this.targetMemberId = targetMemberId;
    }

    public String getCouponCode() {
        return couponCode;
    }

    public void setCouponCode(String couponCode) {
        this.couponCode = couponCode;
    }

    public String getSourcePhone() {
        return sourcePhone;
    }

    public void setSourcePhone(String sourcePhone) {
        this.sourcePhone = sourcePhone;
    }

    public String getTargetPhone() {
        return targetPhone;
    }

    public void setTargetPhone(String targetPhone) {
        this.targetPhone = targetPhone;
    }
}
