package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request;

import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponInvalidTypeEnum;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * 作废优惠券dto
 */
public class CouponInvalidReqDto implements Serializable {

    @ApiModelProperty(name = "couponInvalidTypeEnum", value = "优惠券作废类型枚举类")
    private CouponInvalidTypeEnum couponInvalidTypeEnum;

    @ApiModelProperty(name = "ids", value = "优惠券id集合")
    private List<Long> ids;

    @ApiModelProperty(name = "codes", value = "优惠券券码集合")
    private List<String> codes;

    @ApiModelProperty(name = "couponCode", value = "优惠券编号")
    private String couponCode;

    @ApiModelProperty(name = "userId", value = "会员id")
    private Long userId;

    @ApiModelProperty(name = "paymentCode", value = "支付编号")
    private String paymentCode;

    @ApiModelProperty(name = "outerOrderCode", value = "外部订单号")
    private String outerOrderCode;

    @ApiModelProperty(name = "couponTemplateCodes", value = "优惠券模板编号")
    private List<String> couponTemplateCodes;

    @ApiModelProperty(name = "activityCodes", value = "活动编号, 记录小程序领券时的营销活动id、营销定向推券的活动id、app领券时记录app后台的活动编号、储值赠礼的充值流水id")
    private List<String> activityCodes;

    public CouponInvalidReqDto() {
    }

    public CouponInvalidTypeEnum getCouponInvalidTypeEnum() {
        return couponInvalidTypeEnum;
    }

    public void setCouponInvalidTypeEnum(CouponInvalidTypeEnum couponInvalidTypeEnum) {
        this.couponInvalidTypeEnum = couponInvalidTypeEnum;
    }

    public List<Long> getIds() {
        return ids;
    }

    public void setIds(List<Long> ids) {
        this.ids = ids;
    }

    public List<String> getCodes() {
        return codes;
    }

    public void setCodes(List<String> codes) {
        this.codes = codes;
    }

    public String getCouponCode() {
        return couponCode;
    }

    public void setCouponCode(String couponCode) {
        this.couponCode = couponCode;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getPaymentCode() {
        return paymentCode;
    }

    public void setPaymentCode(String paymentCode) {
        this.paymentCode = paymentCode;
    }

    public String getOuterOrderCode() {
        return outerOrderCode;
    }

    public void setOuterOrderCode(String outerOrderCode) {
        this.outerOrderCode = outerOrderCode;
    }

    public List<String> getCouponTemplateCodes() {
        return couponTemplateCodes;
    }

    public void setCouponTemplateCodes(List<String> couponTemplateCodes) {
        this.couponTemplateCodes = couponTemplateCodes;
    }

    public List<String> getActivityCodes() {
        return activityCodes;
    }

    public void setActivityCodes(List<String> activityCodes) {
        this.activityCodes = activityCodes;
    }
}
