/**
 * @(#)CouponItemRangeQueryReqDto.java 1.0 2019年1月10日
 *
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 优惠券商品使用范围查询请求dto
 * 
 * @author 水镜
 * @since 2.0.0
 */
@ApiModel(value = "CouponItemRangeQueryReqDto", description = "优惠券商品使用范围查询请求dto")
public class CouponItemRangeQueryReqDto extends RequestDto {

	private static final long serialVersionUID = 1L;

	/**
	 * 商品id
	 */
	@ApiModelProperty(name = "itemId", value = "商品id")
	private Long itemId;

	/**
	 * 类目id
	 */
	@ApiModelProperty(name = "categoryId", value = "类目id")
	private Long categoryId;

	/**
	 * 店铺ID
	 */
	@ApiModelProperty(name = "shopId", value = "店铺ID")
	private Long shopId;

	/**
	 * 商户ID
	 */
	@ApiModelProperty(name = "sellerId", value = "商户ID")
	private Long sellerId;

	public Long getItemId() {
		return itemId;
	}

	public void setItemId(Long itemId) {
		this.itemId = itemId;
	}

	public Long getCategoryId() {
		return categoryId;
	}

	public void setCategoryId(Long categoryId) {
		this.categoryId = categoryId;
	}

	public Long getShopId() {
		return shopId;
	}

	public void setShopId(Long shopId) {
		this.shopId = shopId;
	}

	public Long getSellerId() {
		return sellerId;
	}

	public void setSellerId(Long sellerId) {
		this.sellerId = sellerId;
	}

}
