/*
 * *
 *  * @(#)CouponItemReqDto.java 2.0.0 19-1-9 下午2:12
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModelProperty;

/**
 * 优惠券商品使用范围dto
 * 
 * @author luo.lei
 * @since 2.0.0
 */
public class CouponItemReqDto extends RequestDto {

	private static final long serialVersionUID = 1L;

	/**
	 * 优惠券模板编号
	 */
	@ApiModelProperty(name = "couponTemplateId", value = "优惠券模板(新增时不需要填)")
	private Long couponTemplateId;

	/**
	 * 商品使用范围（SELLER：商户、SHOP：店铺、CATEGORY：类目、ITEM：商品）
	 */
	@ApiModelProperty(name = "itemRange", value = "商品使用范围（SELLER：商户、SHOP：店铺、CATEGORY：类目、ITEM：商品）")
	private String itemRange;

	/**
	 * 业务ID
	 */
	@ApiModelProperty(name = "bizId")
	private Long bizId;

	/**
	 * 扩展字段，存放json
	 */
	@ApiModelProperty(name = "extension", value = "扩展字段")
	private String extension;

	public void setCouponTemplateId(Long couponTemplateId) {
		this.couponTemplateId = couponTemplateId;
	}

	public Long getCouponTemplateId() {
		return this.couponTemplateId;
	}

	public String getItemRange() {
		return itemRange;
	}

	public void setItemRange(String itemRange) {
		this.itemRange = itemRange;
	}

	public Long getBizId() {
		return bizId;
	}

	public void setBizId(Long bizId) {
		this.bizId = bizId;
	}

	public void setExtension(String extension) {
		this.extension = extension;
	}

	public String getExtension() {
		return this.extension;
	}

}
