package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 券包请求dto
 *
 * @author 浮云
 */
@ApiModel(
        value = "CouponPackReqDto",
        description = "券包请求dto"
)
public class CouponPackReqDto extends RequestDto {


    @ApiModelProperty(name = "couponPackName", value = "券包名称")
    @NotNull
    private String couponPackName;

    @ApiModelProperty(name = "couponPackUrl", value = "券包url")
    private String couponPackUrl;

    /**
     * 券包说明
     */
    @ApiModelProperty(name = "remark", value = "券包说明")
    private String remark;

    /**
     * 券包类型 1=营销类, 2=权益类, 3=付费类
     */
    @ApiModelProperty(name = "couponPackType", value = "券包类型 1=营销类, 2=权益类, 3=付费类")
    private Integer couponPackType;

    @ApiModelProperty(name = "pushType", value = "优惠券包的发放类型(默认0:部分发放)")
    private Integer pushType;

    @ApiModelProperty(name = "relationType", value = "关联方式(0:手动,1:个性化)")
    private Integer relationType;

    @ApiModelProperty(name = "couponPackTemplateReqDtos", value = "优惠券模板信息集合")
    private List<CouponPackTemplateReqDto> couponPackTemplateReqDtos;

    public String getCouponPackName() {
        return couponPackName;
    }

    public void setCouponPackName(String couponPackName) {
        this.couponPackName = couponPackName;
    }

    public String getCouponPackUrl() {
        return couponPackUrl;
    }

    public void setCouponPackUrl(String couponPackUrl) {
        this.couponPackUrl = couponPackUrl;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Integer getCouponPackType() {
        return couponPackType;
    }

    public void setCouponPackType(Integer couponPackType) {
        this.couponPackType = couponPackType;
    }

    public Integer getPushType() {
        return pushType;
    }

    public void setPushType(Integer pushType) {
        this.pushType = pushType;
    }

    public Integer getRelationType() {
        return relationType;
    }

    public void setRelationType(Integer relationType) {
        this.relationType = relationType;
    }

    public List<CouponPackTemplateReqDto> getCouponPackTemplateReqDtos() {
        return couponPackTemplateReqDtos;
    }

    public void setCouponPackTemplateReqDtos(List<CouponPackTemplateReqDto> couponPackTemplateReqDtos) {
        this.couponPackTemplateReqDtos = couponPackTemplateReqDtos;
    }

}
