/*
 * *
 *  * @(#)CouponQueryReqDto.java 2.0.0 1/10/19 8:21 PM
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author luo.lei
 * @since 2.0.0
 */
@ApiModel
public class CouponQueryReqDto extends RequestDto {

    private static final long serialVersionUID = 3833862254539014721L;


    /**
     * 券类型（现金券：CASH、折扣券：DISCOUNT）
     */
    @ApiModelProperty(name = "couponType" , value = "券类型（现金券：CASH、折扣券：DISCOUNT）")
    private String couponType;

    /**
     * 优惠券名称
     */
    @ApiModelProperty(name = "couponName" , value = "优惠券名称")
    private String couponName;

    /**
     * 渠道，ONLINE：线上渠道，OFFLINE：线下渠道
     */
    @ApiModelProperty(name = "channel" , value = "渠道，ONLINE：线上渠道，OFFLINE：线下渠道")
    private String channel;

    /**
     * 叠加使用类型（NO：不允许叠加使用、YES_DIF：不同券定义允许叠加使用、YES_DIF_SAME：不同券定义&相同券定义不同的券都允许叠加）
     */
    @ApiModelProperty(name = "useSuperimposedType" , value = "叠加使用类型（NO：不允许叠加使用、YES_DIF：不同券定义允许叠加使用、YES_DIF_SAME：不同券定义&相同券定义不同的券都允许叠加）")
    private String useSuperimposedType;

    /**
     * 优惠券编码
     */
    @ApiModelProperty(name = "couponCode" , value = "优惠券编码")
    private String couponCode;


    /**
     * 生效时间开始
     */
    @ApiModelProperty(name = "effectiveTimeBeginTime" , value = "生效时间开始")
    private String effectiveTimeBeginTime;


    /**
     * 生效时间结束
     */
    @ApiModelProperty(name = "effectiveTimeEndTime" , value = "生效时间结束")
    private String effectiveTimeEndTime;

    /**
     * 失效时间开始
     */
    @ApiModelProperty(name = "invalidTimeBeginTime" , value = "失效时间开始")
    private String invalidTimeBeginTime;

    /**
     * 失效时间结束
     */
    @ApiModelProperty(name = "invalidTimeEndTime" , value = "失效时间结束")
    private String invalidTimeEndTime;

    /**
     * 状态（NOT_CONSUMED：未消费、HAS_CONSUMED：已消费、FREEZE：冻结）
     */
    @ApiModelProperty(name = "couponStatus" , value = "状态（NOT_CONSUMED：未消费、HAS_CONSUMED：已消费、FREEZE：冻结）")
    private String couponStatus;


    /**
     * 活动编号
     */
    @ApiModelProperty(name = "activityId" , value = "活动编号")
    private Long activityId;

    /**
     * 券模板编号
     */
    @ApiModelProperty(name = "couponTemplateId" , value = "券模板编号")
    private Long couponTemplateId;

    /**
     * 商品使用范围（使用范围：ALL：全部商品、PART）
     */
    @ApiModelProperty(name = "itemRange" , value = "商品使用范围（使用范围：ALL：全部商品、PART）")
    private String itemRange;

    @ApiModelProperty(name = "sellerId" , value = "商品id")
    private Long sellerId;

    @ApiModelProperty(name = "shopId" , value = "店铺id")
    private Long shopId;

    /**
     * 创建开始时间
     */
    @ApiModelProperty(name = "createBeginTime" , value = "创建开始时间")
    private String createBeginTime;

    /**
     * 创建开始结束
     */
    @ApiModelProperty(name = "createEndTime" , value = "创建开始结束")
    private String createEndTime;


    public String getCouponType() {
        return couponType;
    }

    public void setCouponType(String couponType) {
        this.couponType = couponType;
    }

    public String getCouponName() {
        return couponName;
    }

    public void setCouponName(String couponName) {
        this.couponName = couponName;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getUseSuperimposedType() {
        return useSuperimposedType;
    }

    public void setUseSuperimposedType(String useSuperimposedType) {
        this.useSuperimposedType = useSuperimposedType;
    }

    public String getCouponCode() {
        return couponCode;
    }

    public void setCouponCode(String couponCode) {
        this.couponCode = couponCode;
    }

    public String getEffectiveTimeBeginTime() {
        return effectiveTimeBeginTime;
    }

    public void setEffectiveTimeBeginTime(String effectiveTimeBeginTime) {
        this.effectiveTimeBeginTime = effectiveTimeBeginTime;
    }

    public String getEffectiveTimeEndTime() {
        return effectiveTimeEndTime;
    }

    public void setEffectiveTimeEndTime(String effectiveTimeEndTime) {
        this.effectiveTimeEndTime = effectiveTimeEndTime;
    }

    public String getInvalidTimeBeginTime() {
        return invalidTimeBeginTime;
    }

    public void setInvalidTimeBeginTime(String invalidTimeBeginTime) {
        this.invalidTimeBeginTime = invalidTimeBeginTime;
    }

    public String getInvalidTimeEndTime() {
        return invalidTimeEndTime;
    }

    public void setInvalidTimeEndTime(String invalidTimeEndTime) {
        this.invalidTimeEndTime = invalidTimeEndTime;
    }

    public String getCouponStatus() {
        return couponStatus;
    }

    public void setCouponStatus(String couponStatus) {
        this.couponStatus = couponStatus;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Long getCouponTemplateId() {
        return couponTemplateId;
    }

    public void setCouponTemplateId(Long couponTemplateId) {
        this.couponTemplateId = couponTemplateId;
    }

    public String getItemRange() {
        return itemRange;
    }

    public void setItemRange(String itemRange) {
        this.itemRange = itemRange;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public String getCreateBeginTime() {
        return createBeginTime;
    }

    public void setCreateBeginTime(String createBeginTime) {
        this.createBeginTime = createBeginTime;
    }

    public String getCreateEndTime() {
        return createEndTime;
    }

    public void setCreateEndTime(String createEndTime) {
        this.createEndTime = createEndTime;
    }
}
