package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request;

import com.dtyunxi.cube.biz.commons.annotation.SqlFilterProperty;
import com.dtyunxi.cube.biz.commons.enums.SqlOperator;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.List;

/**
 * 优惠券列表查询dto
 *
 * @author 浮云
 */
@ApiModel(
        value = "CouponReqDto",
        description = "优惠券查询dto"
)
public class  CouponReqDto extends RequestDto {

    @ApiModelProperty(name = "couponTemplateId", value = "优惠券模板id")
    private Long couponTemplateId;

    @ApiModelProperty(name = "couponTemplateCode", value = "优惠券模板编号")
    private String couponTemplateCode;

    /**
     * 核销会员编号
     */
    @ApiModelProperty(name = "useMemberNo", value = "核销会员编号")
    private String useMemberNo;

    /**
     * 核销店铺编号
     */
    @ApiModelProperty(name = "useStoreCode", value = "核销店铺编号")
    private String useStoreCode;

    @ApiModelProperty(name = "useStoreName", value = "核销店铺名称")
    private String useStoreName;

    @ApiModelProperty(name = "shopType", value = "适用店铺, 10=所有店铺, 20=线上店铺, 30=线下店铺, 40=自定义店铺")
    private Integer shopType;

    @ApiModelProperty(name = "couponCode", value = "优惠券码")
    private String couponCode;

    @ApiModelProperty(name = "userPhone", value = "领取人手机号")
    @SqlFilterProperty(ignore = true)
    private String userPhone;

    @ApiModelProperty(name = "userId", value = "券归属人（领取人手机号对应userId）")
    private Long userId;

    @ApiModelProperty(name = "couponStatus", value = "券状态，10-已创建，20-已核销，30-已作废")
    private String couponStatus;

    @ApiModelProperty(name = "batchNo", value = "批次号")
    private String batchNo;

    @ApiModelProperty(name = "createTimeStart", value = "生效时间（起始）")
    @SqlFilterProperty(operator = SqlOperator.ge, column = "createTime")
    private Date createTimeStart;

    @ApiModelProperty(name = "createTimeEnd", value = "生效时间（结束）")
    @SqlFilterProperty(operator = SqlOperator.le, column = "createTime")
    private Date createTimeEnd;

    @ApiModelProperty(name = "effectiveTimeStart", value = "生效时间（起始）")
    @SqlFilterProperty(operator = SqlOperator.ge, column = "effectiveTime")
    private Date effectiveTimeStart;

    @ApiModelProperty(name = "effectiveTimeEnd", value = "生效时间（结束）")
    @SqlFilterProperty(operator = SqlOperator.le, column = "effectiveTime")
    private Date effectiveTimeEnd;

    @ApiModelProperty(name = "invalidTimeStart", value = "失效时间（起始）")
    @SqlFilterProperty(operator = SqlOperator.ge, column = "invalidTime")
    private Date invalidTimeStart;

    @ApiModelProperty(name = "invalidTimeEnd", value = "失效时间（结束）")
    @SqlFilterProperty(operator = SqlOperator.le, column = "invalidTime")
    private Date invalidTimeEnd;

    @ApiModelProperty(name = "useTimeStart", value = "核销时间（起始）")
    @SqlFilterProperty(operator = SqlOperator.ge, column = "useTime")
    private Date useTimeStart;

    @ApiModelProperty(name = "useTimeEnd", value = "核销时间（结束）")
    @SqlFilterProperty(operator = SqlOperator.le, column = "useTime")
    private Date useTimeEnd;

    @ApiModelProperty(
            name = "activityCode",
            value = "活动编号, 记录小程序领券时的营销活动id、营销定向推券到活动id、app领券时记录app后台的活动编号"
    )
    @SqlFilterProperty(operator = SqlOperator.eq, column = "activityCode")
    private String activityCode;

    @ApiModelProperty(
            name = "couponCodes",
            value = "券码集合"
    )
    @SqlFilterProperty(operator = SqlOperator.in, column = "couponCode")
    private List<String> couponCodes;

    @ApiModelProperty(
            name = "couponTemplateCodes",
            value = "优惠券模板编码集合"
    )
    @SqlFilterProperty(operator = SqlOperator.in, column = "couponTemplateCode")
    private List<String> couponTemplateCodes;

    @ApiModelProperty(
            name = "activityCodes",
            value = "营销活动代码集合"
    )
    @SqlFilterProperty(operator = SqlOperator.in, column = "activityCode")
    private List<String> activityCodes;

    @ApiModelProperty(
            name = "shopTypes",
            value = "店铺类型集合"
    )
    @SqlFilterProperty(operator = SqlOperator.in, column = "shopType")
    private List<Integer> shopTypes;

    @ApiModelProperty(name = "couponStatusLit", value = "券状态集合")
    @SqlFilterProperty(operator = SqlOperator.in, column = "couponStatus")
    private List<String> couponStatusLit;

    @ApiModelProperty(name = "orderCode", value = "订单编号")
    private String orderCode;

    @ApiModelProperty(
            name = "receiveTimeBegin",
            value = "领取时间开始区间"
    )
    @SqlFilterProperty(operator = SqlOperator.ge, column = "receiveTime")
    private Date receiveTimeBegin;

    @ApiModelProperty(
            name = "receiveTimeEnd",
            value = "领取时间结束区间"
    )
    @SqlFilterProperty(operator = SqlOperator.le, column = "receiveTime")
    private Date receiveTimeEnd;

    @ApiModelProperty(
            name = "orderBy",
            value = "升序字段,多个字段时逗号隔开"
    )
    private String orderBy;

    @ApiModelProperty(
            name = "orderByDesc",
            value = "降序字段,多个字段时逗号隔开"
    )
    private String orderByDesc;

    /**
     * 优惠券模板ids
     */
    private String[] templateIds;

    public Long getCouponTemplateId() {
        return couponTemplateId;
    }

    public void setCouponTemplateId(Long couponTemplateId) {
        this.couponTemplateId = couponTemplateId;
    }

    public String getCouponTemplateCode() {
        return couponTemplateCode;
    }

    public void setCouponTemplateCode(String couponTemplateCode) {
        this.couponTemplateCode = couponTemplateCode;
    }

    public Integer getShopType() {
        return shopType;
    }

    public void setShopType(Integer shopType) {
        this.shopType = shopType;
    }

    public String getCouponCode() {
        return couponCode;
    }

    public void setCouponCode(String couponCode) {
        this.couponCode = couponCode;
    }

    public String getUserPhone() {
        return userPhone;
    }

    public void setUserPhone(String userPhone) {
        this.userPhone = userPhone;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getCouponStatus() {
        return couponStatus;
    }

    public void setCouponStatus(String couponStatus) {
        this.couponStatus = couponStatus;
    }

    public String getBatchNo() {
        return batchNo;
    }

    public void setBatchNo(String batchNo) {
        this.batchNo = batchNo;
    }

    public Date getCreateTimeStart() {
        return createTimeStart;
    }

    public void setCreateTimeStart(Date createTimeStart) {
        this.createTimeStart = createTimeStart;
    }

    public Date getCreateTimeEnd() {
        return createTimeEnd;
    }

    public void setCreateTimeEnd(Date createTimeEnd) {
        this.createTimeEnd = createTimeEnd;
    }

    public Date getEffectiveTimeStart() {
        return effectiveTimeStart;
    }

    public void setEffectiveTimeStart(Date effectiveTimeStart) {
        this.effectiveTimeStart = effectiveTimeStart;
    }

    public Date getEffectiveTimeEnd() {
        return effectiveTimeEnd;
    }

    public void setEffectiveTimeEnd(Date effectiveTimeEnd) {
        this.effectiveTimeEnd = effectiveTimeEnd;
    }

    public Date getInvalidTimeStart() {
        return invalidTimeStart;
    }

    public void setInvalidTimeStart(Date invalidTimeStart) {
        this.invalidTimeStart = invalidTimeStart;
    }

    public Date getInvalidTimeEnd() {
        return invalidTimeEnd;
    }

    public void setInvalidTimeEnd(Date invalidTimeEnd) {
        this.invalidTimeEnd = invalidTimeEnd;
    }

    public Date getUseTimeStart() {
        return useTimeStart;
    }

    public void setUseTimeStart(Date useTimeStart) {
        this.useTimeStart = useTimeStart;
    }

    public Date getUseTimeEnd() {
        return useTimeEnd;
    }

    public void setUseTimeEnd(Date useTimeEnd) {
        this.useTimeEnd = useTimeEnd;
    }

    public String getActivityCode() {
        return activityCode;
    }

    public void setActivityCode(String activityCode) {
        this.activityCode = activityCode;
    }

    public List<String> getCouponCodes() {
        return couponCodes;
    }

    public void setCouponCodes(List<String> couponCodes) {
        this.couponCodes = couponCodes;
    }

    public List<String> getActivityCodes() {
        return activityCodes;
    }

    public List<String> getCouponTemplateCodes() {
        return couponTemplateCodes;
    }

    public void setCouponTemplateCodes(List<String> couponTemplateCodes) {
        this.couponTemplateCodes = couponTemplateCodes;
    }

    public void setActivityCodes(List<String> activityCodes) {
        this.activityCodes = activityCodes;
    }

    public List<Integer> getShopTypes() {
        return shopTypes;
    }

    public void setShopTypes(List<Integer> shopTypes) {
        this.shopTypes = shopTypes;
    }

    public List<String> getCouponStatusLit() {
        return couponStatusLit;
    }

    public void setCouponStatusLit(List<String> couponStatusLit) {
        this.couponStatusLit = couponStatusLit;
    }

    public String getOrderBy() {
        return orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public String getOrderByDesc() {
        return orderByDesc;
    }

    public void setOrderByDesc(String orderByDesc) {
        this.orderByDesc = orderByDesc;
    }

    public String getOrderCode() {
        return orderCode;
    }

    public void setOrderCode(String orderCode) {
        this.orderCode = orderCode;
    }

    public String getUseStoreName() {
        return useStoreName;
    }

    public void setUseStoreName(String useStoreName) {
        this.useStoreName = useStoreName;
    }

    public Date getReceiveTimeBegin() {
        return receiveTimeBegin;
    }

    public void setReceiveTimeBegin(Date receiveTimeBegin) {
        this.receiveTimeBegin = receiveTimeBegin;
    }

    public Date getReceiveTimeEnd() {
        return receiveTimeEnd;
    }

    public void setReceiveTimeEnd(Date receiveTimeEnd) {
        this.receiveTimeEnd = receiveTimeEnd;
    }

    public String[] getTemplateIds() {
        return templateIds;
    }

    public void setTemplateIds(String[] templateIds) {
        this.templateIds = templateIds;
    }

    public String getUseMemberNo() {
        return useMemberNo;
    }

    public void setUseMemberNo(String useMemberNo) {
        this.useMemberNo = useMemberNo;
    }

    public String getUseStoreCode() {
        return useStoreCode;
    }

    public void setUseStoreCode(String useStoreCode) {
        this.useStoreCode = useStoreCode;
    }
}
