package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request;

import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateExtRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 单条发送优惠券Dto
 *
 * @author 浮云
 */
@ApiModel(
        value = "CouponSendReqDto",
        description = "单条发送优惠券Dto"
)
public class CouponSendReqDto extends RequestDto {

    @ApiModelProperty(name = "couponTemplateId", value = "优惠券模板id")
    private Long couponTemplateId;

    @ApiModelProperty(name = "memberId", value = "发放的用户id")
    private Long memberId;

    @ApiModelProperty(name = "sendType", value = "发放方式，1-手工领券，2-拼团券，3-系统推券")
    private Integer sendType;

    @ApiModelProperty(name = "activityCode", value = "活动编号, 记录小程序领券时的营销活动id、营销定向推券的活动id、app领券时记录app后台的活动编号、储值赠礼的营销活动id")
    private String activityCode;

    @ApiModelProperty(name = "channel", value = "券领取渠道")
    private String channel;

    @ApiModelProperty(name = "outerOrderCode", value = "外部订单号，如淘宝订单号")
    private String outerOrderCode;

    /**
     * 优惠券模板
     * 这里传递这个字段是为了提高程序性能 避免多次读库或者缓存中间件
     * 该信息不由外部系统传递
     */
    private CouponTemplateExtRespDto temp;

    public Long getCouponTemplateId() {
        return couponTemplateId;
    }

    public void setCouponTemplateId(Long couponTemplateId) {
        this.couponTemplateId = couponTemplateId;
    }

    public Long getMemberId() {
        return memberId;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }

    public Integer getSendType() {
        return sendType;
    }

    public void setSendType(Integer sendType) {
        this.sendType = sendType;
    }

    public String getActivityCode() {
        return activityCode;
    }

    public void setActivityCode(String activityCode) {
        this.activityCode = activityCode;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getOuterOrderCode() {
        return outerOrderCode;
    }

    public void setOuterOrderCode(String outerOrderCode) {
        this.outerOrderCode = outerOrderCode;
    }

    public CouponTemplateExtRespDto getTemp() {
        return temp;
    }

    public void setTemp(CouponTemplateExtRespDto temp) {
        this.temp = temp;
    }
}
