package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 优惠券发放模板信息dto
 *
 * @author 浮云
 */
@ApiModel(
        value = "CouponSendTemplateReqDto",
        description = "优惠券发放模板信息dto"
)
public class CouponSendTemplateReqDto implements Serializable {

    @ApiModelProperty(name = "couponTemplateId", value = "优惠券模板id")
    private Long couponTemplateId;

    @ApiModelProperty(name = "couponTemplateCode", value = "优惠券模板编号")
    private String couponTemplateCode;

    @ApiModelProperty(name = "sendNum", value = "本次发放券数量")
    private Integer sendNum;

    @ApiModelProperty(name = "couponTemplateName", value = "优惠券模板名称")
    private String couponTemplateName;

    public String getCouponTemplateName() {
        return couponTemplateName;
    }
    public void setCouponTemplateName(String couponTemplateName) {
        this.couponTemplateName = couponTemplateName;
    }

    public CouponSendTemplateReqDto(Long couponTemplateId, Integer sendNum) {
        this.couponTemplateId = couponTemplateId;
        this.sendNum = sendNum;
    }

    public CouponSendTemplateReqDto(String couponTemplateCode, Integer sendNum) {
        this.couponTemplateCode = couponTemplateCode;
        this.sendNum = sendNum;
    }

    public CouponSendTemplateReqDto() {
    }

    public Long getCouponTemplateId() {
        return couponTemplateId;
    }

    public void setCouponTemplateId(Long couponTemplateId) {
        this.couponTemplateId = couponTemplateId;
    }

    public String getCouponTemplateCode() {
        return couponTemplateCode;
    }

    public void setCouponTemplateCode(String couponTemplateCode) {
        this.couponTemplateCode = couponTemplateCode;
    }

    public Integer getSendNum() {
        return sendNum;
    }

    public void setSendNum(Integer sendNum) {
        this.sendNum = sendNum;
    }
}
