package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request;

import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActionReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityRelationReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ConditionReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.AuditStatusEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 创建优惠券模板dto
 * @author li.jundong
 * @date: 2019/6/24 15:57
 */
@ApiModel(
        value = "CouponTemplateCreateExtReqDto",
        description = "优惠券活动创建Dto"
)
public class CouponTemplateCreateExtReqDto extends RequestDto {

    @ApiModelProperty(
            name = "marketingCode",
            value = "营销活动代码"
    )
    @NotNull
    private String marketingCode;

    @ApiModelProperty(
            name = "couponCode",
            value = "优惠券编码"
    )
    @NotNull
    private String couponCode;

    @ApiModelProperty(
            name = "couponName",
            value = "优惠券名称"
    )
    @NotNull
    private String couponName;

    @ApiModelProperty(
            name = "totalIssueQuantity",
            value = "发放总数量"
    )
    @NotNull
    private Long totalIssueQuantity;

    @ApiModelProperty(
            name = "amount",
            value = "优惠券金额阀值"
    )
    @NotNull
    private BigDecimal amount;

    @ApiModelProperty(
            name = "effective_time",
            value = "生效时间"
    )
    private Date effectiveTime;

    @ApiModelProperty(
            name = "invalidTime",
            value = "失效时间"
    )
    private Date invalidTime;

    /**
     *  领取开始时间
     */
    @ApiModelProperty(name = "receiveStartTime", value = "领取开始时间")
    private Date receiveStartTime;

    /**
     *  领取截止时间
     */
    @ApiModelProperty(name = "receive_end_time", value = "receiveEndTime")
    private Date receiveEndTime;

    @ApiModelProperty(
            name = "couponValue",
            value = "面值（单位：元或百分比）"
    )
    @NotNull
    private BigDecimal couponValue;

    @ApiModelProperty(
            name = "couponCategory",
            value = "券类别, 10=定额现金券（满减）, 50=满折券， 40=提货券"
    )
    @NotNull
    private Integer couponCategory;

    @ApiModelProperty(
            name = "couponType",
            value = "券类型，01=团购券, 02=APP提货券, 03=福利券, 04=客情券, 05=优惠券"
    )
    @NotNull
    private String couponType;

    @ApiModelProperty(
            name = "activityStatus",
            value = "活动状态（NEW：新建、DISABLE：禁用、READY：就绪、ACTIVATE：活动中、TIMEOUT：暂停、FINISH：活动结束）"
    )
    private ActivityStatusEnum activityStatusEnum;

    @ApiModelProperty(
            name = "auditStatus",
            value = "审核状态（NEW：新建、WAIT_AUDIT：待审核、AUDIT_PASS：审核通过、AUDIT_REFUSE：审核不通过）"
    )
    private AuditStatusEnum auditStatusEnum;

    @ApiModelProperty(
            name = "execExpression",
            value = "定时执行表达式（quartz表达式）"
    )
    private String execExpression;

    @ApiModelProperty(
            name = "activityTemplateId",
            value = "活动模版编号"
    )
    private Long activityTemplateId;

    @ApiModelProperty(
            name = "activityItems",
            value = "活动商品"
    )
    private List<CouponItemReqDto> activityItems;

    @ApiModelProperty(
            name = "conditions",
            value = "活动条件实例"
    )
    private List<ConditionReqDto> conditions;

    @ApiModelProperty(
            name = "actions",
            value = "活动动作实例"
    )
    private List<ActionReqDto> actions;

    @ApiModelProperty(
            name = "itemRange",
            value = "商品使用范围（SELLER：商户、SHOP：店铺、CATEGORY：类目、ITEM：商品）"
    )
    private String itemRange;

    @ApiModelProperty(
            name = "userIds",
            value = "活动参与人"
    )
    private List<Long> userIds;

    @ApiModelProperty(
            name = "sellerId",
            value = "商户ID"
    )
    private Long sellerId;

    @ApiModelProperty(
            name = "shopId",
            value = "店铺ID"
    )
    private Long shopId;

    @ApiModelProperty(
            name = "couponTemplateStatus",
            value = "优惠券模板状态,10=已创建, 20=已激活, 30=已停用, 40=已作废"
    )
    private String couponTemplateStatus;

    @ApiModelProperty(
            name = "isDirectional",
            value = "是否定向券, 1是0否"
    )
    private Integer isDirectional;

    @ApiModelProperty(
            name = "mutexType",
            value = "10=不限制互斥, 20=与所有券互斥, 30=与订单级电子券互斥, 40=与商品级电子券互斥, 50=与平台券互斥，60=与店铺券互斥"
    )
    private Integer mutexType;

    @ApiModelProperty(
            name = "shopType",
            value = "10=所有店铺, 20=线上店铺, 30=线下店铺, 40=自定义店铺"
    )
    private Integer shopType;

    @ApiModelProperty(
            name = "hierarchy",
            value = "使用层级, 10=订单电子券, 20=品类电子券, 30=商品电子券，40=店铺电子券，50=通用层级"
    )
    private String hierarchy;

    @ApiModelProperty(
            name = "purpose",
            value = "10=售后安抚, 20=会员活动, 21=会员维护, 22=会员福利, 30=客商团购, 40=主题促销H5游戏," +
                    "41=新店开业/老店店庆, 42=异业合作, 43=地推活动, 44=商品活动, 50=其它"
    )
    private Integer purpose;

    @ApiModelProperty(
            name = "supplier",
            value = "券供应商"
    )
    private String supplier;

    @ApiModelProperty(
            name = "isGroupPurchase",
            value = "是否团购券，1是0否"
    )
    private Integer isGroupPurchase;

    @ApiModelProperty(
            name = "groupPurchasePrice",
            value = "团购价格"
    )
    private BigDecimal groupPurchasePrice;

    @ApiModelProperty(
            name = "validityType",
            value = "有效期类型,1固定日期，2动态时期"
    )
    private Integer validityType;

    @ApiModelProperty(
            name = "dynamicDate",
            value = "动态日期配置{\"afterDate\":\"1\",\"day\":\"2\"}"
    )
    private String dynamicDate;

    @ApiModelProperty(
            name = "remark",
            value = "描述"
    )
    private String remark;

    @ApiModelProperty(
            name = "ruleExplain",
            value = "规则说明"
    )
    private String ruleExplain;

    @ApiModelProperty(
            name = "isGenerateCode",
            value = "是否生成券码"
    )
    private String isGenerateCode;

    /**
     * 成本中心
     */
    @ApiModelProperty(name = "issueDept", value = "成本中心")
    private String issueDept;

    /**
     * 公司代码
     */
    @ApiModelProperty(name = "bukrs", value = "公司代码")
    private String bukrs;

    /**
     *  是否与门店促销互斥，1是0否
     */
    @ApiModelProperty(name = "isStoreMutex", value = "是否与门店促销互斥，1是0否")
    private Integer isStoreMutex;

    /**
     *  OA申请人工号
     */
    @ApiModelProperty(name = "applicantNo", value = "OA申请人工号")
    private String applicantNo;

    /**
     *  OA申请人姓名
     */
    @ApiModelProperty(name = "applicantName", value = "OA申请人姓名")
    private String applicantName;

    /**
     * 券范围类型：10=平台券，20=店铺券
     */
    @ApiModelProperty(name = "couponRange", value = "券范围类型：10=平台券，20=店铺券")
    private Integer couponRange;

    @ApiModelProperty(name = "tag", value = "活动标签")
    private String tag;

    /**
     * 组织id
     */
    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;

    /**
     * 组织名称
     */
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;

    /**
     * 优惠券服务类型（1产品体验 2新品尝鲜 3家电清洗 4家电保养 5.活动入场券
     */
    @ApiModelProperty(name = "serviceType", value = "优惠券服务类型（1产品体验 2新品尝鲜 3家电清洗 4家电保养 5.活动入场券")
    private Integer serviceType;

    @ApiModelProperty(
            name = "activityRelations",
            value = "活动关系"
    )
    private List<ActivityRelationReqDto> activityRelations;

    @ApiModelProperty(name = "selectType", value = "适用商品：0不限，1指定商品，2指定品类，")
    private Integer  selectType;

    @ApiModelProperty(name = "selectCustomer", value = "适用客户：0不限，1指定类型，2指定客户")
    private Integer selectCustomer;

    @ApiModelProperty(name = "customerTypeIds", value = "客户类型")
    private String customerTypeIds;

    @ApiModelProperty(name = "customerAreaCodes", value = "客户区域")
    private String customerAreaCodes;

    public Integer getSelectType() {
        return selectType;
    }

    public void setSelectType(Integer selectType) {
        this.selectType = selectType;
    }

    public Integer getSelectCustomer() {
        return selectCustomer;
    }

    public void setSelectCustomer(Integer selectCustomer) {
        this.selectCustomer = selectCustomer;
    }

    public String getCustomerTypeIds() {
        return customerTypeIds;
    }

    public void setCustomerTypeIds(String customerTypeIds) {
        this.customerTypeIds = customerTypeIds;
    }

    public String getCustomerAreaCodes() {
        return customerAreaCodes;
    }

    public void setCustomerAreaCodes(String customerAreaCodes) {
        this.customerAreaCodes = customerAreaCodes;
    }

    public Integer getServiceType() {
        return serviceType;
    }

    public void setServiceType(Integer serviceType) {
        this.serviceType = serviceType;
    }

    public String getMarketingCode() {
        return marketingCode;
    }

    public void setMarketingCode(String marketingCode) {
        this.marketingCode = marketingCode;
    }

    public String getCouponCode() {
        return couponCode;
    }

    public void setCouponCode(String couponCode) {
        this.couponCode = couponCode;
    }

    public String getCouponName() {
        return couponName;
    }

    public void setCouponName(String couponName) {
        this.couponName = couponName;
    }

    public Long getTotalIssueQuantity() {
        return totalIssueQuantity;
    }

    public void setTotalIssueQuantity(Long totalIssueQuantity) {
        this.totalIssueQuantity = totalIssueQuantity;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Date getEffectiveTime() {
        return effectiveTime;
    }

    public void setEffectiveTime(Date effectiveTime) {
        this.effectiveTime = effectiveTime;
    }

    public Date getInvalidTime() {
        return invalidTime;
    }

    public void setInvalidTime(Date invalidTime) {
        this.invalidTime = invalidTime;
    }

    public BigDecimal getCouponValue() {
        return couponValue;
    }

    public void setCouponValue(BigDecimal couponValue) {
        this.couponValue = couponValue;
    }

    public Integer getCouponCategory() {
        return couponCategory;
    }

    public void setCouponCategory(Integer couponCategory) {
        this.couponCategory = couponCategory;
    }

    public String getCouponType() {
        return couponType;
    }

    public void setCouponType(String couponType) {
        this.couponType = couponType;
    }

    public ActivityStatusEnum getActivityStatusEnum() {
        return activityStatusEnum;
    }

    public void setActivityStatusEnum(ActivityStatusEnum activityStatusEnum) {
        this.activityStatusEnum = activityStatusEnum;
    }

    public AuditStatusEnum getAuditStatusEnum() {
        return auditStatusEnum;
    }

    public void setAuditStatusEnum(AuditStatusEnum auditStatusEnum) {
        this.auditStatusEnum = auditStatusEnum;
    }

    public String getExecExpression() {
        return execExpression;
    }

    public void setExecExpression(String execExpression) {
        this.execExpression = execExpression;
    }

    public Long getActivityTemplateId() {
        return activityTemplateId;
    }

    public void setActivityTemplateId(Long activityTemplateId) {
        this.activityTemplateId = activityTemplateId;
    }

    public List<CouponItemReqDto> getActivityItems() {
        return activityItems;
    }

    public void setActivityItems(List<CouponItemReqDto> activityItems) {
        this.activityItems = activityItems;
    }

    public List<ConditionReqDto> getConditions() {
        return conditions;
    }

    public void setConditions(List<ConditionReqDto> conditions) {
        this.conditions = conditions;
    }

    public List<ActionReqDto> getActions() {
        return actions;
    }

    public void setActions(List<ActionReqDto> actions) {
        this.actions = actions;
    }

    public String getItemRange() {
        return itemRange;
    }

    public void setItemRange(String itemRange) {
        this.itemRange = itemRange;
    }

    public List<Long> getUserIds() {
        return userIds;
    }

    public void setUserIds(List<Long> userIds) {
        this.userIds = userIds;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public String getCouponTemplateStatus() {
        return couponTemplateStatus;
    }

    public void setCouponTemplateStatus(String couponTemplateStatus) {
        this.couponTemplateStatus = couponTemplateStatus;
    }

    public Integer getIsDirectional() {
        return isDirectional;
    }

    public void setIsDirectional(Integer isDirectional) {
        this.isDirectional = isDirectional;
    }

    public Integer getMutexType() {
        return mutexType;
    }

    public void setMutexType(Integer mutexType) {
        this.mutexType = mutexType;
    }

    public Integer getShopType() {
        return shopType;
    }

    public void setShopType(Integer shopType) {
        this.shopType = shopType;
    }

    public String getHierarchy() {
        return hierarchy;
    }

    public void setHierarchy(String hierarchy) {
        this.hierarchy = hierarchy;
    }

    public Integer getPurpose() {
        return purpose;
    }

    public void setPurpose(Integer purpose) {
        this.purpose = purpose;
    }

    public String getSupplier() {
        return supplier;
    }

    public void setSupplier(String supplier) {
        this.supplier = supplier;
    }

    public Integer getIsGroupPurchase() {
        return isGroupPurchase;
    }

    public void setIsGroupPurchase(Integer isGroupPurchase) {
        this.isGroupPurchase = isGroupPurchase;
    }

    public BigDecimal getGroupPurchasePrice() {
        return groupPurchasePrice;
    }

    public void setGroupPurchasePrice(BigDecimal groupPurchasePrice) {
        this.groupPurchasePrice = groupPurchasePrice;
    }

    public Integer getValidityType() {
        return validityType;
    }

    public void setValidityType(Integer validityType) {
        this.validityType = validityType;
    }

    public String getDynamicDate() {
        return dynamicDate;
    }

    public void setDynamicDate(String dynamicDate) {
        this.dynamicDate = dynamicDate;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getRuleExplain() {
        return ruleExplain;
    }

    public void setRuleExplain(String ruleExplain) {
        this.ruleExplain = ruleExplain;
    }

    public String getIsGenerateCode() {
        return isGenerateCode;
    }

    public void setIsGenerateCode(String isGenerateCode) {
        this.isGenerateCode = isGenerateCode;
    }

    public String getIssueDept() {
        return issueDept;
    }

    public void setIssueDept(String issueDept) {
        this.issueDept = issueDept;
    }

    public String getBukrs() {
        return bukrs;
    }

    public void setBukrs(String bukrs) {
        this.bukrs = bukrs;
    }

    public Integer getIsStoreMutex() {
        return isStoreMutex;
    }

    public void setIsStoreMutex(Integer isStoreMutex) {
        this.isStoreMutex = isStoreMutex;
    }

    public String getApplicantNo() {
        return applicantNo;
    }

    public void setApplicantNo(String applicantNo) {
        this.applicantNo = applicantNo;
    }

    public String getApplicantName() {
        return applicantName;
    }

    public void setApplicantName(String applicantName) {
        this.applicantName = applicantName;
    }

    public Integer getCouponRange() {
        return couponRange;
    }

    public void setCouponRange(Integer couponRange) {
        this.couponRange = couponRange;
    }

    public Date getReceiveStartTime() {
        return receiveStartTime;
    }

    public void setReceiveStartTime(Date receiveStartTime) {
        this.receiveStartTime = receiveStartTime;
    }

    public Date getReceiveEndTime() {
        return receiveEndTime;
    }

    public void setReceiveEndTime(Date receiveEndTime) {
        this.receiveEndTime = receiveEndTime;
    }

    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public List<ActivityRelationReqDto> getActivityRelations() {
        return activityRelations;
    }

    public void setActivityRelations(List<ActivityRelationReqDto> activityRelations) {
        this.activityRelations = activityRelations;
    }
}
