package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.dtyunxi.cube.biz.commons.annotation.SqlFilterProperty;
import com.dtyunxi.cube.biz.commons.enums.SqlOperator;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 优惠券模板列表查询对象
 * @author li.jundong
 * @date: 2019/6/21 15:17
 */
@ApiModel(
        value = "CouponTemplateExtReqDto",
        description = "优惠券模板查询dto"
)
public class CouponTemplateExtReqDto extends RequestDto {

    @ApiModelProperty(
            name = "couponCode",
            value = "优惠券模板编号"
    )
    private String couponCode;

    @ApiModelProperty(
            name = "couponName",
            value = "优惠券名称"
    )
    @SqlFilterProperty(operator = SqlOperator.like)
    private String couponName;

    @ApiModelProperty(
            name = "couponTemplateStatus",
            value = "优惠券模板状态, 10=已创建, 20=已激活, 30=已停用, 40=已作废"
    )
    private String couponTemplateStatus;

    @ApiModelProperty(
            name = "purpose",
            value = "用途归类, 10=售后安抚, 20=会员活动, 21=会员维护, 22=会员福利, 30=客商团购, 40=主题促销H5游戏, 41=新店开业/老店店庆, " +
                    "42=异业合作, 43=地推活动, 44=商品活动, 50=其它"
    )
    private Integer purpose;

    @ApiModelProperty(
            name = "hierarchy",
            value = "使用层级ORDER=订单电子券,ITEM=商品电子券,CATEGORY=品类电子券"
    )
    private String hierarchy;

    @ApiModelProperty(
            name = "couponType",
            value = "优惠券类型, 01=团购券, 02=APP提货券, 03=福利券, 04=客情券, 05=优惠券"
    )
    @SqlFilterProperty(operator = SqlOperator.eq, column = "coupon_type")
    private String couponType;

    @ApiModelProperty(
            name = "isGenerateCode",
            value = "是否生成券编码（Y：是、N：否，默认N）"
    )
    private String isGenerateCode;

    @ApiModelProperty(
            name = "effectiveTimeBeginTime",
            value = "生效时间开始区间"
    )
    @SqlFilterProperty(operator = SqlOperator.ge, column = "effectiveTime")
    private Date effectiveTimeBeginTime;

    @ApiModelProperty(
            name = "effectiveTimeEndTime",
            value = "生效时间结束区间"
    )
    @SqlFilterProperty(operator = SqlOperator.le, column = "effectiveTime")
    private Date effectiveTimeEndTime;

    @ApiModelProperty(
            name = "invalidTimeBeginTime",
            value = "失效时间开始区间"
    )
    @SqlFilterProperty(operator = SqlOperator.ge, column = "invalidTime")
    private Date invalidTimeBeginTime;

    @ApiModelProperty(
            name = "invalidTimeEndTime",
            value = "失效时间结束区间"
    )
    @SqlFilterProperty(operator = SqlOperator.le, column = "invalidTime")
    private Date invalidTimeEndTime;

    @ApiModelProperty(
            name = "createTimeBeginTime",
            value = "创建时间开始区间"
    )
    @SqlFilterProperty(operator = SqlOperator.ge, column = "createTime")
    private Date createTimeBeginTime;

    @ApiModelProperty(
            name = "createTimeEndTime",
            value = "创建时间结束区间"
    )
    @SqlFilterProperty(operator = SqlOperator.le, column = "createTime")
    private Date createTimeEndTime;

    @ApiModelProperty(
            name = "isGroupPurchase",
            value = "是否团购券，1是0否"
    )
    @SqlFilterProperty(operator = SqlOperator.eq, column = "isGroupPurchase")
    private Integer isGroupPurchase;

    @ApiModelProperty(
            name = "ids",
            value = "优惠券id集合"
    )
    @SqlFilterProperty(operator = SqlOperator.in, column = "id")
    private List<Long> ids;

    @ApiModelProperty(
            name = "applicantName",
            value = "OA申请人姓名"
    )
    private String applicantName;

    @ApiModelProperty(name = "validityType", value = "有效期类型,1固定日期，2动态时期")
    private Integer validityType;

    @ApiModelProperty(name = "couponValueBegin", value = "券面额查询条件开始值")
    @SqlFilterProperty(operator = SqlOperator.ge, column = "couponValue")
    private BigDecimal couponValueBegin;

    @ApiModelProperty(name = "couponValueEnd", value = "券面额查询条件结束值")
    @SqlFilterProperty(operator = SqlOperator.le, column = "couponValue")
    private BigDecimal couponValueEnd;

    @ApiModelProperty(name = "amountBegin", value = "最低消费金额查询条件开始值")
    @SqlFilterProperty(operator = SqlOperator.ge, column = "amount")
    private BigDecimal amountBegin;

    @ApiModelProperty(name = "amountEnd", value = "最低消费金额查询条件结束值")
    @SqlFilterProperty(operator = SqlOperator.le, column = "amount")
    private BigDecimal amountEnd;

    @ApiModelProperty(name = "couponRange", value = "券范围类型：10=平台券，20=店铺券")
    @SqlFilterProperty(operator = SqlOperator.eq, column = "couponRange")
    private Integer couponRange;

    @ApiModelProperty(
            name = "receiveTimeBegin",
            value = "领取时间开始区间"
    )
    @SqlFilterProperty(operator = SqlOperator.ge, column = "receiveStartTime")
    private Date receiveTimeBegin;

    @ApiModelProperty(
            name = "receiveTimeEnd",
            value = "领取时间结束区间"
    )
    @SqlFilterProperty(operator = SqlOperator.le, column = "receiveStartTime")
    private Date receiveTimeEnd;

    @ApiModelProperty(name = "sellerId", value = "商户id")
    @SqlFilterProperty(operator = SqlOperator.eq, column = "sellerId")
    private Long sellerId ;


    public String getCouponCode() {
        return couponCode;
    }

    public void setCouponCode(String couponCode) {
        this.couponCode = couponCode;
    }

    public String getCouponName() {
        return couponName;
    }

    public void setCouponName(String couponName) {
        this.couponName = couponName;
    }

    public String getCouponTemplateStatus() {
        return couponTemplateStatus;
    }

    public void setCouponTemplateStatus(String couponTemplateStatus) {
        this.couponTemplateStatus = couponTemplateStatus;
    }

    public Integer getPurpose() {
        return purpose;
    }

    public void setPurpose(Integer purpose) {
        this.purpose = purpose;
    }

    public String getHierarchy() {
        return hierarchy;
    }

    public void setHierarchy(String hierarchy) {
        this.hierarchy = hierarchy;
    }

    public String getCouponType() {
        return couponType;
    }

    public void setCouponType(String couponType) {
        this.couponType = couponType;
    }

    public String getIsGenerateCode() {
        return isGenerateCode;
    }

    public void setIsGenerateCode(String isGenerateCode) {
        this.isGenerateCode = isGenerateCode;
    }

    public Date getEffectiveTimeBeginTime() {
        return effectiveTimeBeginTime;
    }

    public void setEffectiveTimeBeginTime(Date effectiveTimeBeginTime) {
        this.effectiveTimeBeginTime = effectiveTimeBeginTime;
    }

    public Date getEffectiveTimeEndTime() {
        return effectiveTimeEndTime;
    }

    public void setEffectiveTimeEndTime(Date effectiveTimeEndTime) {
        this.effectiveTimeEndTime = effectiveTimeEndTime;
    }

    public Date getInvalidTimeBeginTime() {
        return invalidTimeBeginTime;
    }

    public void setInvalidTimeBeginTime(Date invalidTimeBeginTime) {
        this.invalidTimeBeginTime = invalidTimeBeginTime;
    }

    public Date getInvalidTimeEndTime() {
        return invalidTimeEndTime;
    }

    public void setInvalidTimeEndTime(Date invalidTimeEndTime) {
        this.invalidTimeEndTime = invalidTimeEndTime;
    }

    public Date getCreateTimeBeginTime() {
        return createTimeBeginTime;
    }

    public void setCreateTimeBeginTime(Date createTimeBeginTime) {
        this.createTimeBeginTime = createTimeBeginTime;
    }

    public Date getCreateTimeEndTime() {
        return createTimeEndTime;
    }

    public void setCreateTimeEndTime(Date createTimeEndTime) {
        this.createTimeEndTime = createTimeEndTime;
    }

    public Integer getIsGroupPurchase() {
        return isGroupPurchase;
    }

    public void setIsGroupPurchase(Integer isGroupPurchase) {
        this.isGroupPurchase = isGroupPurchase;
    }

    public List<Long> getIds() {
        return ids;
    }

    public void setIds(List<Long> ids) {
        this.ids = ids;
    }

    public String getApplicantName() {
        return applicantName;
    }

    public void setApplicantName(String applicantName) {
        this.applicantName = applicantName;
    }

    public Integer getValidityType() {
        return validityType;
    }

    public void setValidityType(Integer validityType) {
        this.validityType = validityType;
    }

    public BigDecimal getCouponValueBegin() {
        return couponValueBegin;
    }

    public void setCouponValueBegin(BigDecimal couponValueBegin) {
        this.couponValueBegin = couponValueBegin;
    }

    public BigDecimal getCouponValueEnd() {
        return couponValueEnd;
    }

    public void setCouponValueEnd(BigDecimal couponValueEnd) {
        this.couponValueEnd = couponValueEnd;
    }

    public BigDecimal getAmountBegin() {
        return amountBegin;
    }

    public void setAmountBegin(BigDecimal amountBegin) {
        this.amountBegin = amountBegin;
    }

    public BigDecimal getAmountEnd() {
        return amountEnd;
    }

    public void setAmountEnd(BigDecimal amountEnd) {
        this.amountEnd = amountEnd;
    }

    public Integer getCouponRange() {
        return couponRange;
    }

    public void setCouponRange(Integer couponRange) {
        this.couponRange = couponRange;
    }

    public Date getReceiveTimeBegin() {
        return receiveTimeBegin;
    }

    public void setReceiveTimeBegin(Date receiveTimeBegin) {
        this.receiveTimeBegin = receiveTimeBegin;
    }

    public Date getReceiveTimeEnd() {
        return receiveTimeEnd;
    }

    public void setReceiveTimeEnd(Date receiveTimeEnd) {
        this.receiveTimeEnd = receiveTimeEnd;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public static void main(String[] args) {
        System.out.println(JSON.toJSONString(new CouponTemplateExtReqDto(), SerializerFeature.WriteMapNullValue));
    }
}
