/**
 * @(#)CouponTemplateQueryReqDto.java 1.0 2020/10/14
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.List;

/**
 * 优惠券模板查询dto
 *
 * @author wu.sheng
 * @date 2020/10/14 17:05
 */
@ApiModel(value = "CouponTemplateQueryReqDto", description = "优惠券模板查询dto")
public class CouponTemplateQueryReqDto extends RequestDto {

    @ApiModelProperty(name = "couponCode", value = "优惠券编码")
    private String couponCode;

    @ApiModelProperty(name = "couponName", value = "优惠券名称")
    private String couponName;

    @ApiModelProperty(name = "couponTemplateStatus", value = "优惠券模板状态:10=已创建, 20=已激活, 30=已停用, 40=已作废")
    private String couponTemplateStatus;

    @ApiModelProperty(name = "couponType", value = "优惠券名称")
    private String couponType;

    @ApiModelProperty(name = "sellerId", value = "商户id")
    private Long sellerId;

    @ApiModelProperty(name = "shopId", value = "店铺id")
    private Long shopId;

    @ApiModelProperty(name = "couponRange", value = "券范围类型：10=平台券，20=店铺券，不传则查全部")
    private Integer couponRange;

    @ApiModelProperty(name = "activityTemplateId", value = "活动模板id")
    private Long activityTemplateId;

    /**
     * 领取开始时间
     */
    @ApiModelProperty(name = "receiveStartTime", value = "领取开始时间")
    private Date receiveStartTime;

    /**
     * 领取截止时间
     */
    @ApiModelProperty(name = "receiveEndTime", value = "领取截止时间")
    private Date receiveEndTime;

    @ApiModelProperty(name = "auditStatus", value = "审核状态")
    private String auditStatus;

    @ApiModelProperty(name = "couponCategory", value = "券类别, 10=定额现金券（满减）, 50=满折券, 40=兑换券（提货券）")
    private Integer couponCategory;

    @ApiModelProperty(name = "couponCategoryList", value = "券类别列表，优先级大于单个")
    private List<Integer> couponCategoryList;

    @ApiModelProperty(name = "couponRanges", value = "券范围类型：10=平台券，20=店铺券，多个逗号隔开")
    private String couponRanges;

    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getCouponCode() {
        return couponCode;
    }

    public void setCouponCode(String couponCode) {
        this.couponCode = couponCode;
    }

    public String getCouponName() {
        return couponName;
    }

    public void setCouponName(String couponName) {
        this.couponName = couponName;
    }

    public String getCouponTemplateStatus() {
        return couponTemplateStatus;
    }

    public void setCouponTemplateStatus(String couponTemplateStatus) {
        this.couponTemplateStatus = couponTemplateStatus;
    }

    public String getCouponType() {
        return couponType;
    }

    public void setCouponType(String couponType) {
        this.couponType = couponType;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getActivityTemplateId() {
        return activityTemplateId;
    }

    public void setActivityTemplateId(Long activityTemplateId) {
        this.activityTemplateId = activityTemplateId;
    }

    public Integer getCouponRange() {
        return couponRange;
    }

    public void setCouponRange(Integer couponRange) {
        this.couponRange = couponRange;
    }

    public Date getReceiveStartTime() {
        return receiveStartTime;
    }

    public void setReceiveStartTime(Date receiveStartTime) {
        this.receiveStartTime = receiveStartTime;
    }

    public Date getReceiveEndTime() {
        return receiveEndTime;
    }

    public void setReceiveEndTime(Date receiveEndTime) {
        this.receiveEndTime = receiveEndTime;
    }

    public String getAuditStatus() {
        return auditStatus;
    }

    public void setAuditStatus(String auditStatus) {
        this.auditStatus = auditStatus;
    }

    public Integer getCouponCategory() {
        return couponCategory;
    }

    public void setCouponCategory(Integer couponCategory) {
        this.couponCategory = couponCategory;
    }

    public List<Integer> getCouponCategoryList() {
        return couponCategoryList;
    }

    public void setCouponCategoryList(List<Integer> couponCategoryList) {
        this.couponCategoryList = couponCategoryList;
    }

    public String getCouponRanges() {
        return couponRanges;
    }

    public void setCouponRanges(String couponRanges) {
        this.couponRanges = couponRanges;
    }
}
