package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request;

import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.AuditStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.Bool;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.Channel;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.UseSuperimposedType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 优惠券模板
 *
 * @author tuyun
 * @since 2.0.0
 */
@ApiModel(value = "CouponTemplateReqDto", description = "优惠券模版")
public class CouponTemplateReqDto extends RequestDto {
    private static final long serialVersionUID = 7027472132710436163L;
    /**
     * 优惠券编码
     */
//    @NotNull(message = "优惠券编码不能为空")
    @ApiModelProperty(name = "couponCode", value = "优惠券编码")
    private String couponCode;

    /**
     * 优惠券名称
     */
//    @NotNull(message = "优惠券名称不能为空")
    @ApiModelProperty(name = "couponName", value = "优惠券名称")
    private String couponName;

    /**
     * 备注说明
     */
    @ApiModelProperty(name = "remark", value = "备注说明")
    private String remark;

    /**
     * 使用渠道（ONLINE：线上渠道、OFFLINE：线下渠道）
     */
//    @NotNull(message = "使用渠道必须选【ONLINE（线上渠道），OFFLINE（线下渠道）】之一")
    @ApiModelProperty(name = "couponName", value = "使用渠道")
    private Channel channel;

    /**
     * 状态（DRAFT：草稿、HAS_CONSUMED：待审核、AUDIT_PASS：审核通过、FREEZE：驳回）
     */
//    @NotNull(message = "状态必须选【NEW（草稿），HAS_CONSUMED（待审核），AUDIT_PASS（审核通过）】之一")
    @ApiModelProperty(name = "couponTemplateStatus", value = "状态必须选【NEW（草稿），HAS_CONSUMED（待审核），AUDIT_PASS（审核通过）】之一")
    private AuditStatusEnum couponTemplateStatus;

    /**
     * 发放总数量（单位：张）
     */
    @ApiModelProperty(name = "totalIssueQuantity", value = "发放总数量")
    private Long totalIssueQuantity;


    /**
     * 生效时间
     */
//    @NotNull(message = "生效时间不能为空")
    @ApiModelProperty(name = "effectiveTime", value = "生效时间")
    private Date effectiveTime;

    /**
     * 失效时间
     */
//    @NotNull(message = "失效时间")
    @ApiModelProperty(name = "invalidTime", value = "失效时间")
    private Date invalidTime;

    /**
     * 面值（单位：元或百分比）
     */
    @ApiModelProperty(name = "couponValue", value = "面值")
    private BigDecimal couponValue;

    /**
     * 券类型（现金券：CASH、折扣券：DISCOUNT）
     */
//    @NotNull(message = "卡券类型【CASH(现金券),DISCOUNT(折扣券)】")
    @ApiModelProperty(name = "couponType", value = "卡券类型【CASH(现金券),DISCOUNT(折扣券)】")
    private CouponType couponType;

    /**
     * 是否生成券编码（Y：是、N：否，默认N）
     */
//    @NotNull(message = "是否生成券编码【Y,N】")
    @ApiModelProperty(name = "generateCode", value = "是否生成券编码【Y,N】")
    private Bool generateCode;

    /**
     * 叠加使用类型（NO：不允许叠加使用、YES_DIF：不同券定义允许叠加使用、YES_DIF_SAME：不同券定义&相同券定义不同的券都允许叠加）
     */
//    @NotNull(message = "叠加使用类型【NO（不允许叠加使用），YES_DIF（不同券定义允许叠加使用），YES_DIF_SAME（不同券定义&相同券定义不同的券都允许叠加）】")
    @ApiModelProperty(name = "useSuperimposedType", value = "叠加使用类型【NO（不允许叠加使用），YES_DIF（不同券定义允许叠加使用），YES_DIF_SAME（不同券定义&相同券定义不同的券都允许叠加）】")
    private UseSuperimposedType useSuperimposedType;

    /**
     * 是否预生成（提前生成优惠券）
     */
    @ApiModelProperty(name = "generate", value = "是否预生成")
    private Bool generate;

    /**
     * 商品使用范围（使用范围：ALL：全部商品、PART）
     */
//    @NotNull(message = "商品使用范围【ALL(全部商品),PART(部分)】")
    @ApiModelProperty(name = "itemRange", value = "商品使用范围【ALL(全部商品),PART(部分)】")
    private String itemRange;

    /**
     * 金额阈值，当达到该阈值，才能使用券
     */
//    @NotNull(message = "金额阈值")
    @ApiModelProperty(name = "amount", value = "金额阈值")
    private BigDecimal amount;

    /**
     * 商品范围类型 CATEGORY、ITEM
     */
    @ApiModelProperty(name = "itemScopeType", value = "当前优惠券模版，关联的是商品还是类目")
    private String itemScopeType;

    /**
     * 活动编号
     */
//    @NotNull(message = "活动编号")
    @ApiModelProperty(name = "activityId", value = "活动编号")
    private Long activityId;

    @ApiModelProperty(name = "activityIds", value = "活动编号列表【查询使用】")
    private List<Long> activityIds;

    /**
     * 扩展字段，存放json
     */
    private String extension;

    /**
     * 状态
     */
    @ApiModelProperty(name = "status", value = "DISABLE(禁用)ENABLE(启用)")
    private String status ;

    public String getItemScopeType() {
        return itemScopeType;
    }

    public void setItemScopeType(String itemScopeType) {
        this.itemScopeType = itemScopeType;
    }

    public String getCouponCode() {
        return couponCode;
    }

    public void setCouponCode(String couponCode) {
        this.couponCode = couponCode;
    }

    public String getCouponName() {
        return couponName;
    }

    public void setCouponName(String couponName) {
        this.couponName = couponName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Channel getChannel() {
        return channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public AuditStatusEnum getCouponTemplateStatus() {
        return couponTemplateStatus;
    }

    public void setCouponTemplateStatus(AuditStatusEnum couponTemplateStatus) {
        this.couponTemplateStatus = couponTemplateStatus;
    }

    public Long getTotalIssueQuantity() {
        return totalIssueQuantity;
    }

    public void setTotalIssueQuantity(Long totalIssueQuantity) {
        this.totalIssueQuantity = totalIssueQuantity;
    }

    public Date getEffectiveTime() {
        return effectiveTime;
    }

    public void setEffectiveTime(Date effectiveTime) {
        this.effectiveTime = effectiveTime;
    }

    public Date getInvalidTime() {
        return invalidTime;
    }

    public void setInvalidTime(Date invalidTime) {
        this.invalidTime = invalidTime;
    }

    public BigDecimal getCouponValue() {
        return couponValue;
    }

    public void setCouponValue(BigDecimal couponValue) {
        this.couponValue = couponValue;
    }

    public CouponType getCouponType() {
        return couponType;
    }

    public void setCouponType(CouponType couponType) {
        this.couponType = couponType;
    }

    public Bool getGenerateCode() {
        return generateCode;
    }

    public void setGenerateCode(Bool generateCode) {
        this.generateCode = generateCode;
    }

    public UseSuperimposedType getUseSuperimposedType() {
        return useSuperimposedType;
    }

    public void setUseSuperimposedType(UseSuperimposedType useSuperimposedType) {
        this.useSuperimposedType = useSuperimposedType;
    }

    public Bool getGenerate() {
        return generate;
    }

    public void setGenerate(Bool generate) {
        this.generate = generate;
    }

    public String getItemRange() {
        return itemRange;
    }

    public void setItemRange(String itemRange) {
        this.itemRange = itemRange;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public List<Long> getActivityIds() {
        return activityIds;
    }

    public void setActivityIds(List<Long> activityIds) {
        this.activityIds = activityIds;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }
}
