package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponMoneyOffDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateBrandDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateItemDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateShopDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

/**
 * 创建优惠券模板dto
 * @author li.jundong
 * @date: 2019/6/24 15:57
 */
@ApiModel(
        value = "CouponTemplateUpdateExtReqDto",
        description = "创建优惠券模板dto"
)
public class CouponTemplateUpdateExtReqDto extends RequestDto {

    @ApiModelProperty(
            name = "id",
            value = "优惠券模板id"
    )
    @NotNull
    private Long id;

    @ApiModelProperty(name = "validityType", value = "有效期类型,1固定日期，2动态时期")
    @NotNull
    private Integer validityType;

    @ApiModelProperty(name = "dynamicDate", value = "动态日期配置{\"afterDate\":\"1\",\"day\":\"2\"}")
    private String dynamicDate;

    /**
     * 生效时间
     */
    @ApiModelProperty(name = "effectiveTime", value = "生效时间")
    private Date effectiveTime;

    /**
     * 失效时间
     */
    @ApiModelProperty(name = "invalidTime", value = "失效时间")
    private Date invalidTime;

    /**
     * 活动描述
     */
    @ApiModelProperty(name = "remark", value = "活动描述")
    private String remark;

    /**
     * 规则说明
     */
    @ApiModelProperty(name = "ruleExplain", value = "规则说明")
    private String ruleExplain;

    /**
     * 优惠券店铺条件
     */
    @ApiModelProperty(name = "shopList", value = "优惠券店铺条件")
    private List<CouponTemplateShopDto> shopList;

    /**
     * 优惠券商品条件
     */
    @ApiModelProperty(name = "itemList", value = "优惠券商品条件")
    private List<CouponTemplateItemDto> itemList;

    /**
     * 优惠券商品条件
     */
    @ApiModelProperty(name = "brandList", value = "优惠券品牌条件")
    private List<CouponTemplateBrandDto> brandList;

    /**
     * 优惠券类目条件
     */
    @ApiModelProperty(name = "catalogIds", value = "优惠券类目条件")
    private List<Long> catalogIds;

    /**
     * 优惠券折扣条件
     */
    @ApiModelProperty(name = "couponMoneyOffDto", value = "优惠券折扣条件")
    private CouponMoneyOffDto couponMoneyOffDto;

    @ApiModelProperty(name = "shopRangeType", value = "店铺范围取值：10=所有店铺，20=线上店铺，30=线下店铺，60=部分店铺，70=排除部分店铺")
    private Integer shopRangeType;

    @ApiModelProperty(
            name = "shopType",
            value = "10=所有店铺, 20=线上店铺, 30=线下店铺, 40=自定义店铺"
    )
    private Integer shopType;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getValidityType() {
        return validityType;
    }

    public void setValidityType(Integer validityType) {
        this.validityType = validityType;
    }

    public String getDynamicDate() {
        return dynamicDate;
    }

    public void setDynamicDate(String dynamicDate) {
        this.dynamicDate = dynamicDate;
    }

    public Date getEffectiveTime() {
        return effectiveTime;
    }

    public void setEffectiveTime(Date effectiveTime) {
        this.effectiveTime = effectiveTime;
    }

    public Date getInvalidTime() {
        return invalidTime;
    }

    public void setInvalidTime(Date invalidTime) {
        this.invalidTime = invalidTime;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getRuleExplain() {
        return ruleExplain;
    }

    public void setRuleExplain(String ruleExplain) {
        this.ruleExplain = ruleExplain;
    }

    public List<CouponTemplateShopDto> getShopList() {
        return shopList;
    }

    public void setShopList(List<CouponTemplateShopDto> shopList) {
        this.shopList = shopList;
    }

    public List<CouponTemplateItemDto> getItemList() {
        return itemList;
    }

    public void setItemList(List<CouponTemplateItemDto> itemList) {
        this.itemList = itemList;
    }

    public List<CouponTemplateBrandDto> getBrandList() {
        return brandList;
    }

    public void setBrandList(List<CouponTemplateBrandDto> brandList) {
        this.brandList = brandList;
    }

    public List<Long> getCatalogIds() {
        return catalogIds;
    }

    public void setCatalogIds(List<Long> catalogIds) {
        this.catalogIds = catalogIds;
    }

    public CouponMoneyOffDto getCouponMoneyOffDto() {
        return couponMoneyOffDto;
    }

    public void setCouponMoneyOffDto(CouponMoneyOffDto couponMoneyOffDto) {
        this.couponMoneyOffDto = couponMoneyOffDto;
    }

    public Integer getShopRangeType() {
        return shopRangeType;
    }

    public void setShopRangeType(Integer shopRangeType) {
        this.shopRangeType = shopRangeType;
    }

    public Integer getShopType() {
        return shopType;
    }

    public void setShopType(Integer shopType) {
        this.shopType = shopType;
    }

    public static void main(String[] args) {
        System.out.println(JSON.toJSONString(new CouponTemplateUpdateExtReqDto(), SerializerFeature.WriteMapNullValue));
    }

}
