/**
 * @(#) CouponCreateReqDto.java 1.0 2018-10-24
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request;

import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActionReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityItemReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ConditionDto;

import java.util.List;

/**
 * 优惠券活动更新Dto
 *
 * @author 魄罗
 * @since 2.0.0
 */
public class CouponUpdateReqDto extends RequestDto {
    private static final long serialVersionUID = 7458961286826142441L;
    /**
     * 优惠券编码
     */
    private String couponCode;
    /**
     * 优惠券名称
     */
    private String couponName;
    /**
     * 说明
     */
    private String remark;
    /**
     * 渠道，ONLINE：线上渠道，OFFLINE：线下渠道
     */
    private String channel;
    /**
     * 状态，DRAFT：草稿、HAS_CONSUMED：待审核、AUDIT_PASS：审核通过、FREEZE：驳回
     */
    private String couponDefineStatus;
    /**
     * 发放总数量
     */
    private Long totalIssueQuantity;

    /**
     * 开始时间
     */
    private String beginTime;
    /**
     * 结束时间
     */
    private String endTime;
    /**
     * 面值（单位：元或百分比）
     */
    private Double couponValue;
    /**
     * 券类型，现金券：CASH，折扣券：DISCOUNT
     */
    private String couponType;
    /**
     * 是否生成券编码（Y：是、N：否，默认N）
     */
    private String isGenerateCode;
    /**
     * 是否允许叠加使用（Y：是、N：否）
     */
    private String isCanSuperimposed;
    /**
     * 是否预生成（提前生成优惠券）
     */
    private String isGenerate;
    /**
     * 活动ID
     */
    private Long activityId;
    /**
     * 扩展字段存放JSON
     */
    private String extension;
    /**
     * 活动状态（ENABLE：启用、DISABLE：停用、ACTIVITYING：活动中、TIMEOUT：暂停、FINISH：活动结束）
     */
    private String activityStatus;
    /**
     * 审核状态（NEW：新建、HAS_CONSUMED：待审核、AUDIT_PASS：审核通过、FREEZE：审核不通过）
     */
    private String auditStatus;
    /**
     * 定时执行表达式（quartz表达式）
     */
    private String execExpression;
    /**
     * 活动模版编号
     */
    private String activityTemplateCode;
    /**
     * 预告时间（不为空，则调用预告逻辑，由定制实现）
     */
    private String noticeTime;
    /**
     * 活动商品
     */
    private List<ActivityItemReqDto> activityItems;
    /**
     * 活动条件实例
     */
    private List<ConditionDto> conditions;
    /**
     * 活动动作实例
     */
    private List<ActionReqDto> actions;

    public String getCouponCode() {
        return couponCode;
    }

    public void setCouponCode(String couponCode) {
        this.couponCode = couponCode;
    }

    public String getCouponName() {
        return couponName;
    }

    public void setCouponName(String couponName) {
        this.couponName = couponName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getCouponDefineStatus() {
        return couponDefineStatus;
    }

    public void setCouponDefineStatus(String couponDefineStatus) {
        this.couponDefineStatus = couponDefineStatus;
    }

    public Long getTotalIssueQuantity() {
        return totalIssueQuantity;
    }

    public void setTotalIssueQuantity(Long totalIssueQuantity) {
        this.totalIssueQuantity = totalIssueQuantity;
    }


    public String getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(String beginTime) {
        this.beginTime = beginTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public Double getCouponValue() {
        return couponValue;
    }

    public void setCouponValue(Double couponValue) {
        this.couponValue = couponValue;
    }

    public String getCouponType() {
        return couponType;
    }

    public void setCouponType(String couponType) {
        this.couponType = couponType;
    }

    public String getIsGenerateCode() {
        return isGenerateCode;
    }

    public void setIsGenerateCode(String isGenerateCode) {
        this.isGenerateCode = isGenerateCode;
    }

    public String getIsCanSuperimposed() {
        return isCanSuperimposed;
    }

    public void setIsCanSuperimposed(String isCanSuperimposed) {
        this.isCanSuperimposed = isCanSuperimposed;
    }

    public String getIsGenerate() {
        return isGenerate;
    }

    public void setIsGenerate(String isGenerate) {
        this.isGenerate = isGenerate;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getActivityStatus() {
        return activityStatus;
    }

    public void setActivityStatus(String activityStatus) {
        this.activityStatus = activityStatus;
    }

    public String getAuditStatus() {
        return auditStatus;
    }

    public void setAuditStatus(String auditStatus) {
        this.auditStatus = auditStatus;
    }

    public String getExecExpression() {
        return execExpression;
    }

    public void setExecExpression(String execExpression) {
        this.execExpression = execExpression;
    }

    public String getActivityTemplateCode() {
        return activityTemplateCode;
    }

    public void setActivityTemplateCode(String activityTemplateCode) {
        this.activityTemplateCode = activityTemplateCode;
    }

    public String getNoticeTime() {
        return noticeTime;
    }

    public void setNoticeTime(String noticeTime) {
        this.noticeTime = noticeTime;
    }

    public List<ActivityItemReqDto> getActivityItems() {
        return activityItems;
    }

    public void setActivityItems(List<ActivityItemReqDto> activityItems) {
        this.activityItems = activityItems;
    }

    public List<ConditionDto> getConditions() {
        return conditions;
    }

    public void setConditions(List<ConditionDto> conditions) {
        this.conditions = conditions;
    }

    public List<ActionReqDto> getActions() {
        return actions;
    }

    public void setActions(List<ActionReqDto> actions) {
        this.actions = actions;
    }
}
