package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 优惠券核销dto
 *
 * @author 浮云
 */
@ApiModel(
        value = "CouponUseReqDto",
        description = "优惠券核销dto"
)
public class CouponUseReqDto extends RequestDto implements Serializable {

    @ApiModelProperty(name = "couponCode", value = "优惠券编号")
    private String couponCode;

    @ApiModelProperty(name = "useMemberId", value = "核销会员id")
    private Long useMemberId;

    @ApiModelProperty(name = "useMemberNo", value = "核销会员编号")
    private String useMemberNo;

    @ApiModelProperty(name = "orderCode", value = "订单编号")
    private String orderCode;

    @ApiModelProperty(name = "paymentCode", value = "支付编号")
    private String paymentCode;

    @ApiModelProperty(name = "usePhone", value = "核销手机号")
    private String usePhone;

    @ApiModelProperty(name = "useChannel", value = "核销渠道")
    private String useChannel;

    @ApiModelProperty(name = "useStoreCode", value = "核销店铺编号")
    private String useStoreCode;

    @ApiModelProperty(name = "useAmount", value = "核销金额")
    private BigDecimal useAmount;

    public CouponUseReqDto(String couponCode, Long useMemberId, String useMemberNo, String orderCode, String paymentCode, String usePhone, String useChannel, String useStoreCode, BigDecimal useAmount) {
        this.couponCode = couponCode;
        this.useMemberId = useMemberId;
        this.useMemberNo = useMemberNo;
        this.orderCode = orderCode;
        this.paymentCode = paymentCode;
        this.usePhone = usePhone;
        this.useChannel = useChannel;
        this.useStoreCode = useStoreCode;
        this.useAmount = useAmount;
    }

    public CouponUseReqDto() {
    }

    public String getCouponCode() {
        return couponCode;
    }

    public void setCouponCode(String couponCode) {
        this.couponCode = couponCode;
    }

    public Long getUseMemberId() {
        return useMemberId;
    }

    public void setUseMemberId(Long useMemberId) {
        this.useMemberId = useMemberId;
    }

    public String getUseMemberNo() {
        return useMemberNo;
    }

    public void setUseMemberNo(String useMemberNo) {
        this.useMemberNo = useMemberNo;
    }

    public String getOrderCode() {
        return orderCode;
    }

    public void setOrderCode(String orderCode) {
        this.orderCode = orderCode;
    }

    public String getPaymentCode() {
        return paymentCode;
    }

    public void setPaymentCode(String paymentCode) {
        this.paymentCode = paymentCode;
    }

    public String getUsePhone() {
        return usePhone;
    }

    public void setUsePhone(String usePhone) {
        this.usePhone = usePhone;
    }

    public String getUseChannel() {
        return useChannel;
    }

    public void setUseChannel(String useChannel) {
        this.useChannel = useChannel;
    }

    public String getUseStoreCode() {
        return useStoreCode;
    }

    public void setUseStoreCode(String useStoreCode) {
        this.useStoreCode = useStoreCode;
    }

    public BigDecimal getUseAmount() {
        return useAmount;
    }

    public void setUseAmount(BigDecimal useAmount) {
        this.useAmount = useAmount;
    }
}
