package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request;

import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 优惠券订单匹配
 * @author li.jundong
 * @date: 2019/7/12 16:38
 */
@ApiModel(value = "OrderMatchCouponReqDto", description = "下单查询可用优惠券实体")
public class OrderMatchCouponReqDto extends RequestDto {

    /**
     * 使用层级
     */
    @ApiModelProperty(value = "hierarchy", name = "使用层级")
    private String hierarchy;

    /**
     * 会员ID
     */
    @ApiModelProperty(value = "memberId", name = "会员id")
    private Long memberId;

    /**
     * 订单时间
     */
    @ApiModelProperty(value = "orderDate", name = "下单时间")
    private Date orderDate;

    /**
     * 订单金额
     */
    @ApiModelProperty(value = "orderAmount", name = "订单金额")
    private BigDecimal orderAmount;

    @ApiModelProperty(value = "itemVos", name = "订单商品列表")
    private List<ItemVo> itemVos;

    public String getHierarchy() {
        return hierarchy;
    }

    public void setHierarchy(String hierarchy) {
        this.hierarchy = hierarchy;
    }

    public Long getMemberId() {
        return memberId;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }

    public Date getOrderDate() {
        return orderDate;
    }

    public void setOrderDate(Date orderDate) {
        this.orderDate = orderDate;
    }

    public BigDecimal getOrderAmount() {
        return orderAmount;
    }

    public void setOrderAmount(BigDecimal orderAmount) {
        this.orderAmount = orderAmount;
    }

    public List<ItemVo> getItemVos() {
        return itemVos;
    }

    public void setItemVos(List<ItemVo> itemVos) {
        this.itemVos = itemVos;
    }
}
